/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.WinSize;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.SessionChannelNG;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.ssh.TerminalModes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class NativeSessionChannel
extends SessionChannelNG {
    private PtyProcess pty;
    private Map<String, String> env;
    private File directory;
    String term = "dumb";
    int cols = 80;
    int rows = 25;
    final String commandProgram = "$SYSTEMROOT\\System32\\cmd.exe";
    final String powershellProgram = "$SYSTEMROOT\\System32\\WindowsPowerShell\\v1.0\\powershell.exe";
    final String powershellEncoding = "ISO-8859-1";

    public NativeSessionChannel(SshConnection con) {
        super(con);
    }

    protected void changeWindowDimensions(int cols, int rows, int width, int height) {
        this.setScreenSize(cols, rows);
    }

    protected void processSignal(String signal) {
    }

    public boolean setEnvironmentVariable(String name, String value) {
        return false;
    }

    protected boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, TerminalModes modes) {
        this.term = term;
        this.cols = cols;
        this.rows = rows;
        return true;
    }

    private void setScreenSize(int width, int height) {
        try {
            this.pty.setWinSize(new WinSize(width, height));
        }
        catch (Exception e) {
            Log.warn((String)String.format("Could not set new terminal size of pty to %d x %d.", width, height), (Object[])new Object[0]);
        }
    }

    protected boolean startShell() {
        try {
            List<String> args = this.configureCommand("", Collections.emptyList());
            HashMap<String, String> penv = this.env == null ? new HashMap<String, String>(System.getenv()) : new HashMap<String, String>(this.env);
            penv.put("TERM", this.term);
            PtyProcessBuilder builder = new PtyProcessBuilder(args.toArray(new String[0]));
            if (this.directory != null) {
                builder.setDirectory(this.directory.getAbsolutePath());
            }
            builder.setConsole(false);
            builder.setEnvironment(penv);
            this.pty = builder.start();
            final InputStream in = this.pty.getInputStream();
            final OutputStream out = this.pty.getOutputStream();
            this.setScreenSize(this.cols, this.rows);
            this.pauseDataCaching();
            ChannelEventListener l = new ChannelEventListener(){

                public void onChannelDataIn(Channel channel, ByteBuffer buffer) {
                    byte[] tmp = new byte[buffer.remaining()];
                    buffer.get(tmp);
                    try {
                        out.write(tmp);
                        out.flush();
                    }
                    catch (IOException e) {
                        Log.error((String)"Error writing data to pty", (Throwable)e, (Object[])new Object[0]);
                        IOUtils.closeStream((OutputStream)out);
                        IOUtils.closeStream((InputStream)in);
                    }
                }
            };
            this.addEventListener(l);
            ((SshServerContext)this.getContext()).getExecutorService().submit(() -> {
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)this.getOutputStream());
                    out.close();
                    int result = this.pty.waitFor();
                    if (result > 0) {
                        throw new IOException("System command exited with error " + result);
                    }
                }
                catch (Exception exception) {
                    try {
                        this.resumeDataCaching();
                    }
                    finally {
                        this.removeEventListener(l);
                    }
                }
                finally {
                    try {
                        this.resumeDataCaching();
                    }
                    finally {
                        this.removeEventListener(l);
                    }
                }
            });
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void onLocalEOF() {
    }

    private String generateWindowsPath(String path) {
        return path.replace("$SYSTEMROOT", StringUtils.defaultIfBlank((CharSequence)System.getenv("SystemRoot"), (CharSequence)"C:\\Windows"));
    }

    protected List<String> configureCommand(String cmd, List<String> cmdArgs) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            if (StringUtils.isBlank((CharSequence)cmd)) {
                String path = this.generateWindowsPath("$SYSTEMROOT\\System32\\WindowsPowerShell\\v1.0\\powershell.exe");
                if (Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
                    args.add(path);
                } else {
                    args.add(this.generateWindowsPath("$SYSTEMROOT\\System32\\cmd.exe"));
                }
            } else {
                args.add(cmd);
            }
        } else {
            if (SystemUtils.IS_OS_MAC_OSX) {
                if (StringUtils.isBlank((CharSequence)cmd) && (cmd = this.findCommand("zsh", "/bin/zsh", "bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh")) == null) {
                    throw new IOException("Cannot find OSX shell.");
                }
            } else if (StringUtils.isBlank((CharSequence)cmd) && (cmd = this.findCommand("bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh")) == null) {
                throw new IOException("Cannot find shell.");
            }
            args.add(cmd);
        }
        return args;
    }

    protected String findCommand(String command, String ... places) {
        String stdbuf = NativeSessionChannel.execAndCapture("which", command);
        if (stdbuf == null) {
            for (String place : places) {
                File f = new File(place);
                if (!f.exists()) continue;
                stdbuf = f.getAbsolutePath();
                break;
            }
        }
        if (stdbuf != null) {
            while (stdbuf.endsWith("\n")) {
                stdbuf = stdbuf.substring(0, stdbuf.length() - 1);
            }
        }
        return stdbuf;
    }

    private static final String execAndCapture(String ... args) {
        try {
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.redirectErrorStream();
            Process process = builder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
            int ret = process.waitFor();
            if (ret == 0) {
                return new String(out.toByteArray());
            }
            throw new IOException("Got non-zero return status.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

