/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import java.nio.file.Path;
import java.nio.file.Paths;

public class CommandLocator {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();

    public static Path getCommandPath(String commandName) {
        String basePath = "bin";
        if (CommandLocator.isWindows()) {
            return Paths.get(basePath, "windows", "x64", commandName + ".exe");
        }
        if (CommandLocator.isMac()) {
            return Paths.get(basePath, "osx", commandName);
        }
        if (CommandLocator.isLinux()) {
            return Paths.get(basePath, "linux", "debian", commandName);
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + OS_NAME);
    }

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static boolean isMac() {
        return OS_NAME.contains("mac");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("nix") || OS_NAME.contains("nux") || OS_NAME.contains("aix");
    }

    public static void main(String[] args) {
        System.out.println("Current OS detected: " + System.getProperty("os.name"));
        System.out.println("------------------------------------------");
        try {
            Path runasPath = CommandLocator.getCommandPath("runas");
            Path verifyUserPath = CommandLocator.getCommandPath("verifyuser");
            System.out.println("Path for 'runas': " + runasPath);
            System.out.println("Path for 'verifyuser': " + verifyUserPath);
        }
        catch (UnsupportedOperationException e) {
            System.err.println(e.getMessage());
        }
    }
}

