/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.client.PseudoTerminalModes;
import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClient;
import com.sshtools.client.tasks.CommandTask;
import com.sshtools.client.tasks.ShellTask;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualShellNG;
import com.sshtools.server.vsession.commands.sftp.SftpClientOptions;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.vsession.commands.ssh.AbstractSshClientCommand;
import com.sshtools.vsession.commands.ssh.CommandUtil;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientOptionsEvaluator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class SshClientCommand
extends AbstractSshClientCommand {
    public SshClientCommand() {
        super("ssh", "Shell", "", "Returns the ssh client shell");
        for (Option option : SftpClientOptions.getOptions()) {
            this.options.addOption(option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCommand(SshClient sshClient, SshClientArguments arguments, final VirtualConsole console) {
        try {
            ShellTask task;
            console.getSessionChannel().pauseDataCaching();
            Connection connection = sshClient.getConnection();
            WindowSizeChange listener = new WindowSizeChange();
            if (CommandUtil.isNotEmpty(arguments.getCommand())) {
                String command = arguments.getCommand();
                CommandTask.CommandTaskBuilder builder = ((CommandTask.CommandTaskBuilder)CommandTask.CommandTaskBuilder.create().withConnection((SshConnection)connection)).withCommand(command).withTermType(console.getTerminal().getType()).withColumns(console.getTerminal().getWidth()).withRows(console.getTerminal().getHeight()).onBeforeExecute((t, session) -> {
                    listener.session = session;
                    ((VirtualShellNG)console.getSessionChannel()).addWindowSizeChangeListener(listener);
                }).onTask((t, session) -> {
                    connection.addTask((ConnectionAwareTask)Task.ofRunnable((SshConnection)connection, c -> IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream())));
                    IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
                }).onClose((t, session) -> ((VirtualShellNG)console.getSessionChannel()).removeWindowSizeChangeListener(listener));
                if (console.getPseudoTerminalModes() != null) {
                    try {
                        builder.withModes(PseudoTerminalModes.PseudoTerminalModesBuilder.create().build());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                task = builder.build();
            } else {
                ShellTask.ShellTaskBuilder builder = ((ShellTask.ShellTaskBuilder)ShellTask.ShellTaskBuilder.create().withConnection((SshConnection)connection)).withTermType(console.getTerminal().getType()).withColumns(console.getTerminal().getWidth()).withRows(console.getTerminal().getHeight()).onBeforeTask((t, session) -> {
                    listener.session = session;
                    ((VirtualShellNG)console.getSessionChannel()).addWindowSizeChangeListener(listener);
                    final ChannelEventListener l = new ChannelEventListener(){

                        public void onChannelDataIn(Channel channel, ByteBuffer buffer) {
                            byte[] tmp = new byte[buffer.remaining()];
                            buffer.get(tmp);
                            try {
                                session.getOutputStream().write(tmp);
                                session.getOutputStream().flush();
                            }
                            catch (IOException e) {
                                Log.error((String)"Error writing data from console", (Throwable)e, (Object[])new Object[0]);
                            }
                        }
                    };
                    console.getSessionChannel().addEventListener(l);
                    session.addEventListener(new ChannelEventListener(){

                        public void onChannelClose(Channel channel) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Detected close of child command so removing channel data listeners", (Object[])new Object[0]);
                            }
                            console.getSessionChannel().removeEventListener(l);
                            session.removeEventListener((ChannelEventListener)this);
                        }
                    });
                }).onTask((t, session) -> IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream())).onClose((t, session) -> ((VirtualShellNG)console.getSessionChannel()).removeWindowSizeChangeListener(listener));
                if (console.getPseudoTerminalModes() != null) {
                    builder.withModes(console.getPseudoTerminalModes());
                }
                task = builder.build();
            }
            connection.addTask((ConnectionAwareTask)task);
            task.waitForever();
        }
        finally {
            console.getSessionChannel().resumeDataCaching();
            console.println();
        }
    }

    @Override
    protected SshClientArguments generateCommandArguments(CommandLine cli, String[] args) throws IOException, PermissionDeniedException {
        return SshClientOptionsEvaluator.evaluate(cli, args, this.console);
    }

    class WindowSizeChange
    implements VirtualShellNG.WindowSizeChangeListener {
        SessionChannelNG session;

        WindowSizeChange() {
        }

        @Override
        public void newSize(int rows, int cols) {
            if (this.session != null) {
                this.session.changeTerminalDimensions(cols, rows, 0, 0);
            }
        }
    }
}

