/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.SessionChannelServer;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.vsession.Environment;
import com.sshtools.server.vsession.Msh;
import com.sshtools.synergy.ssh.TerminalModes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;

public class VirtualConsole {
    Environment env;
    Terminal terminal;
    LineReader reader;
    SshConnection con;
    SessionChannelServer channel;
    Msh shell;
    AbstractFile cwd;
    AbstractFileFactory<?> fileFactory;
    TerminalModes modes;
    static ThreadLocal<VirtualConsole> threadConsoles = new ThreadLocal();

    public VirtualConsole(SessionChannelServer channel, Environment env, Terminal terminal, LineReader reader, Msh shell, TerminalModes modes) throws IOException, PermissionDeniedException {
        this.channel = channel;
        this.con = channel.getConnection();
        this.env = env;
        this.terminal = terminal;
        this.reader = reader;
        this.shell = shell;
        this.fileFactory = ((FileSystemPolicy)this.getContext().getPolicy(FileSystemPolicy.class)).getFileFactory().getFileFactory(this.con);
        this.modes = modes;
    }

    public TerminalModes getPseudoTerminalModes() {
        return this.modes;
    }

    public SshConnection getConnection() {
        return this.con;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public LineReader getLineReader() {
        return this.reader;
    }

    public void clear() {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        this.terminal.flush();
    }

    public void print(char ch) {
        this.terminal.writer().print(ch);
        this.terminal.writer().flush();
    }

    public void print(String str) {
        this.terminal.writer().print(str);
        this.terminal.writer().flush();
    }

    public void println(String str) {
        this.terminal.writer().print(str);
        this.terminal.writer().print("\r\n");
        this.terminal.writer().flush();
    }

    public void println() {
        this.terminal.writer().print("\r\n");
        this.terminal.writer().flush();
    }

    public String readLine(String prompt) {
        return this.reader.readLine(prompt);
    }

    public String readLine(String prompt, Character mask) {
        return this.reader.readLine(prompt, mask);
    }

    public Context getContext() {
        return this.con.getContext();
    }

    public String readLine() {
        return this.reader.readLine();
    }

    public SessionChannelServer getSessionChannel() {
        return this.channel;
    }

    public History getHistory() {
        return this.reader.getHistory();
    }

    public void destroy() {
    }

    public void print(Throwable e) {
        e.printStackTrace(this.terminal.writer());
        this.terminal.writer().flush();
    }

    public Msh getShell() {
        return this.shell;
    }

    public void setCurrentDirectory(String currentDirectory) throws IOException, PermissionDeniedException {
        AbstractFile file;
        if (Objects.isNull(this.cwd)) {
            this.cwd = this.fileFactory.getFile(this.env.getOrDefault("HOME", "/"));
            if (!this.cwd.exists()) {
                this.cwd.createFolder();
                if (!this.cwd.exists()) {
                    throw new FileNotFoundException(String.format("User directory %s does not exist", this.cwd.getName()));
                }
            } else if (!this.cwd.isDirectory()) {
                throw new IOException(String.format("%s is not a directory", this.cwd.getName()));
            }
        }
        if (!(file = this.cwd.resolveFile(currentDirectory)).isDirectory()) {
            throw new IOException(String.format("%s is not a directory", file.getName()));
        }
        this.cwd = file;
        this.env.put("CWD", currentDirectory);
    }

    public AbstractFile getCurrentDirectory() throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.cwd)) {
            this.setCurrentDirectory("");
        }
        return this.cwd;
    }

    public AbstractFileFactory<?> getFileFactory() {
        return this.fileFactory;
    }

    public static VirtualConsole getCurrentConsole() {
        return threadConsoles.get();
    }

    public static void setCurrentConsole(VirtualConsole console) {
        threadConsoles.set(console);
    }

    public static void clearCurrentConsole() {
        threadConsoles.remove();
    }
}

