/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.vsession.CommandFactory;
import com.sshtools.server.vsession.Msh;
import com.sshtools.server.vsession.RootShell;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UnsupportedCommandException;
import com.sshtools.server.vsession.commands.Alias;
import com.sshtools.server.vsession.commands.Catch;
import com.sshtools.server.vsession.commands.Clear;
import com.sshtools.server.vsession.commands.Date;
import com.sshtools.server.vsession.commands.Echo;
import com.sshtools.server.vsession.commands.Env;
import com.sshtools.server.vsession.commands.Exit;
import com.sshtools.server.vsession.commands.Help;
import com.sshtools.server.vsession.commands.Input;
import com.sshtools.server.vsession.commands.ShowLastError;
import com.sshtools.server.vsession.commands.Sleep;
import com.sshtools.server.vsession.commands.Source;
import com.sshtools.server.vsession.commands.Unalias;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ShellCommandFactory
extends CommandFactory<ShellCommand> {
    final List<CommandFactory<? extends ShellCommand>> factories = new ArrayList<CommandFactory<? extends ShellCommand>>();

    @SafeVarargs
    public ShellCommandFactory(CommandFactory<? extends ShellCommand> ... commandFactories) {
        this.installShellCommands();
        this.factories.addAll(Arrays.asList(commandFactories));
    }

    protected void installShellCommands() {
        this.commands.put("alias", Alias.class);
        this.commands.put("unalias", Unalias.class);
        this.commands.put("exit", Exit.class);
        this.commands.put("echo", Echo.class);
        this.commands.put("input", Input.class);
        this.commands.put("date", Date.class);
        this.commands.put("env", Env.class);
        this.commands.put("set", Env.class);
        this.commands.put("error", ShowLastError.class);
        this.commands.put("help", Help.class);
        this.commands.put("msh", Msh.class);
        this.commands.put("source", Source.class);
        this.commands.put("clear", Clear.class);
        this.commands.put("sleep", Sleep.class);
        this.commands.put("catch", Catch.class);
    }

    public void installFactory(CommandFactory<ShellCommand> factory) {
        this.factories.add(factory);
    }

    @Override
    public Set<String> getSupportedCommands() {
        HashSet<String> commands = new HashSet<String>();
        commands.addAll(super.getSupportedCommands());
        for (CommandFactory<? extends ShellCommand> factory : this.factories) {
            commands.addAll(factory.getSupportedCommands());
        }
        return commands;
    }

    @Override
    protected ShellCommand newInstance(String command, SshConnection con) throws UnsupportedCommandException, IllegalAccessException, InstantiationException, IOException, PermissionDeniedException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        for (CommandFactory<? extends ShellCommand> factory : this.factories) {
            if (!factory.supportsCommand(command)) continue;
            return factory.newInstance(command, con);
        }
        return (ShellCommand)super.newInstance(command, con);
    }

    @Override
    public boolean supportsCommand(String command) {
        for (CommandFactory<? extends ShellCommand> factory : this.factories) {
            if (!factory.supportsCommand(command)) continue;
            return true;
        }
        return super.supportsCommand(command);
    }

    public RootShell createShell(SshConnection connection) throws PermissionDeniedException, IOException {
        RootShell shell = new RootShell(this, connection);
        this.configureCommand(shell, connection);
        return shell;
    }

    @Override
    protected void configureCommand(ShellCommand c, SshConnection con) throws IOException, PermissionDeniedException {
        super.configureCommand(c, con);
    }
}

