/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.fs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.server.vsession.CliHelper;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class Ls
extends ShellCommand {
    public Ls() {
        super("ls", "File System", UsageHelper.build("ls [options] path...", "-l, --long\t\t\t\t\t\t        Show details for each individual file/folder", "-a, --all                              Show all files", "-d, --directory                        List directories themeselves, not their contents", "-x, --extended                         Show extended attributes"), "List the contents of a directory.");
        this.setBuiltIn(false);
    }

    @Override
    public void run(String[] args, VirtualConsole process) throws IOException, PermissionDeniedException {
        AbstractFile dir = process.getCurrentDirectory();
        if (args.length == 1) {
            this.list(args, process, dir);
        } else {
            ArrayList<String> paths = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                if (CliHelper.isOption(args[i], "ladx")) continue;
                paths.add(args[i]);
            }
            if (paths.isEmpty()) {
                this.list(args, process, dir);
            } else {
                for (String path : paths) {
                    this.list(args, process, dir.resolveFile(path));
                }
            }
        }
    }

    private void list(String[] args, VirtualConsole process, AbstractFile file) throws IOException, PermissionDeniedException {
        if (file.exists()) {
            if (file.isFile() || file.isDirectory() && CliHelper.hasShortOption(args, 'd')) {
                this.printFile(args, process, file);
            } else {
                List children = file.getChildren();
                Collections.sort(children, new Comparator<AbstractFile>(){

                    @Override
                    public int compare(AbstractFile o1, AbstractFile o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (AbstractFile child : children) {
                    this.printFile(args, process, child);
                }
            }
        } else {
            process.println(this.getCommandName() + ": " + file.getName() + " does not exist.");
        }
    }

    protected void printFile(String[] args, VirtualConsole process, AbstractFile file) throws IOException, PermissionDeniedException {
        if (!file.isHidden() || CliHelper.hasOption(args, 'a', "all")) {
            SftpFileAttributes attrs;
            if (CliHelper.hasOption(args, 'l', "all")) {
                attrs = file.getAttributes();
                String lastModifiedTime = "";
                long size = 0L;
                if (file.isFile()) {
                    size = attrs.size().longValue();
                } else if (file.isDirectory()) {
                    size = 0L;
                }
                long mt = attrs.lastModifiedTime().toMillis();
                long now = System.currentTimeMillis();
                SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy", process.getConnection().getLocale()) : new SimpleDateFormat("MMM dd HH:mm", process.getConnection().getLocale());
                lastModifiedTime = df.format(new Date(mt));
                int linkCount = 0;
                process.println(String.format("%s %-3d %-8s %-8s %10d %-14s %-30s", attrs.toPermissionsString(), linkCount, attrs.bestUsername(), attrs.bestGroup(), size, lastModifiedTime, file.getName()));
            } else {
                process.println(file.getName());
            }
            if (CliHelper.hasOption(args, 'x', "extended")) {
                attrs = file.getAttributes();
                for (String name : attrs.extendedAttributes().keySet()) {
                    byte[] val = (byte[])attrs.extendedAttributes().get(name);
                    process.println(String.format("%" + (CliHelper.hasShortOption(args, 'l') ? 64 : 4) + "s%s", "", name.toString() + "=" + (val == null ? "" : val.toString())));
                }
            }
        }
    }
}

