/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.vsession.Command;
import com.sshtools.server.vsession.CommandConfigurator;
import com.sshtools.server.vsession.UnsupportedCommandException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class CommandFactory<T extends Command> {
    protected HashMap<String, Class<? extends T>> commands = new HashMap();
    protected List<CommandConfigurator<T>> configurators = new ArrayList<CommandConfigurator<T>>();

    public CommandFactory<T> addConfigurator(CommandConfigurator<T> configurator) {
        this.configurators.add(configurator);
        return this;
    }

    public CommandFactory<T> removeConfigurator(CommandConfigurator<T> configurator) {
        this.configurators.add(configurator);
        return this;
    }

    public CommandFactory<T> installCommand(String cmd, Class<? extends T> cls) {
        this.commands.put(cmd, cls);
        return this;
    }

    public CommandFactory<T> installCommand(Class<? extends T> cls) {
        try {
            Command c = (Command)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.commands.put(c.getCommandName(), cls);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return this;
    }

    public CommandFactory<T> uninstallCommand(String cmd) {
        this.commands.remove(cmd);
        return this;
    }

    public Set<String> getSupportedCommands() {
        return this.commands.keySet();
    }

    public boolean supportsCommand(String command) {
        return this.commands.containsKey(command);
    }

    public T createCommand(String command, SshConnection con) throws UnsupportedCommandException, IllegalAccessException, InstantiationException, IOException, PermissionDeniedException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.newInstance(command, con);
    }

    protected T newInstance(String command, SshConnection con) throws UnsupportedCommandException, IllegalAccessException, InstantiationException, IOException, PermissionDeniedException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (!this.commands.containsKey(command)) {
            throw new UnsupportedCommandException(command + " is not a supported command");
        }
        Class<T> cls = this.commands.get(command);
        Command c = (Command)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.configureCommand(c, con);
        for (CommandConfigurator<Command> commandConfigurator : this.configurators) {
            commandConfigurator.configure(c);
        }
        return (T)c;
    }

    protected void configureCommand(T command, SshConnection con) throws IOException, PermissionDeniedException {
    }
}

