/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.os;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.VirtualSessionPolicy;
import com.sshtools.server.vsession.VirtualShellNG;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class Shell
extends ShellCommand {
    private PtyProcess pty;

    public Shell() {
        super("osshell", "System", "osshell", "Run a native shell");
        this.setDescription("The current operating systems shell");
        this.setBuiltIn(false);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        this.runCommand(null, null, null, null, console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand(String cmd, List<String> cmdArgs, File directory, Map<String, String> env, VirtualConsole console) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (cmd == null) {
            cmd = "";
        } else {
            while (cmd.startsWith("/")) {
                cmd = cmd.substring(1);
            }
        }
        String shellCommand = ((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellCommand();
        if (SystemUtils.IS_OS_WINDOWS) {
            if (StringUtils.isBlank((CharSequence)shellCommand)) {
                args.add("C:\\Windows\\System32\\cmd.exe");
            } else {
                args.add(shellCommand);
                args.addAll(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellArguments());
            }
        } else {
            if (StringUtils.isBlank((CharSequence)shellCommand) && (shellCommand = this.findCommand("bash", "/usr/bin/bash", "/bin/bash", "sh", "/usr/bin/sh", "/bin/sh")) == null) {
                throw new IOException("Cannot find shell.");
            }
            args.add(shellCommand);
            args.addAll(((VirtualSessionPolicy)console.getContext().getPolicy(VirtualSessionPolicy.class)).getShellArguments());
        }
        env = env == null ? new HashMap<String, String>() : new HashMap<String, String>(env);
        env.put("TERM", console.getTerminal().getType());
        this.pty = PtyProcess.exec((String[])args.toArray(new String[0]), env, (String)(directory == null ? null : directory.getAbsolutePath()), (boolean)false);
        final InputStream in = this.pty.getInputStream();
        final OutputStream out = this.pty.getOutputStream();
        this.setScreenSize(console.getTerminal().getWidth(), console.getTerminal().getHeight());
        VirtualShellNG shell = (VirtualShellNG)console.getSessionChannel();
        VirtualShellNG.WindowSizeChangeListener listener = new VirtualShellNG.WindowSizeChangeListener(){

            @Override
            public void newSize(int rows, int cols) {
                Shell.this.setScreenSize(cols, rows);
            }
        };
        shell.addWindowSizeChangeListener(listener);
        console.getSessionChannel().enableRawMode();
        console.getSessionChannel().addEventListener(new ChannelEventListener(){

            public void onChannelDataIn(Channel channel, ByteBuffer buffer) {
                byte[] tmp = new byte[buffer.remaining()];
                buffer.get(tmp);
                try {
                    out.write(tmp);
                    out.flush();
                }
                catch (IOException e) {
                    Log.error((String)"Error writing data to pty", (Throwable)e, (Object[])new Object[0]);
                    IOUtils.closeStream((OutputStream)out);
                    IOUtils.closeStream((InputStream)in);
                }
            }
        });
        try {
            IOUtils.copy((InputStream)in, (OutputStream)console.getSessionChannel().getOutputStream());
            out.close();
            int result = this.pty.waitFor();
            if (result > 0) {
                throw new IOException("System command exited with error " + result);
            }
        }
        catch (Exception exception) {
        }
        finally {
            console.getSessionChannel().disableRawMode();
        }
        console.println("===============");
        console.println();
    }

    private String findCommand(String command, String ... places) {
        String stdbuf = Shell.execAndCapture("which", command);
        if (stdbuf == null) {
            for (String place : places) {
                File f = new File(place);
                if (!f.exists()) continue;
                stdbuf = f.getAbsolutePath();
                break;
            }
        }
        if (stdbuf != null) {
            while (stdbuf.endsWith("\n")) {
                stdbuf = stdbuf.substring(0, stdbuf.length() - 1);
            }
        }
        return stdbuf;
    }

    private void setScreenSize(int width, int height) {
        try {
            this.pty.setWinSize(new WinSize(width, height));
        }
        catch (Exception e) {
            Log.warn((String)String.format("Could not set new terminal size of pty to %d x %d.", width, height), (Object[])new Object[0]);
        }
    }

    private static final String execAndCapture(String ... args) {
        try {
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.redirectErrorStream();
            Process process = builder.start();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
            int ret = process.waitFor();
            if (ret == 0) {
                return new String(out.toByteArray());
            }
            throw new IOException("Got non-zero return status.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

