/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SshClientOptionsExtractor {
    private static Set<String> SSH_SINGLE_OPTIONS = new HashSet<String>(Arrays.asList("46AaCfGgKkMNnqsTtVvXxYy".split("")));
    private static Set<String> SSH_DOUBLE_OPTIONS = new HashSet<String>(Arrays.asList("BbcDEeFIiJLlmOopQRSWw".split("")));
    private static Set<String> SSH_CUSTOM_SINGLE_OPTIONS = new HashSet<String>(Arrays.asList("".split("")));
    private static Set<String> SSH_CUSTOM_DOUBLE_OPTIONS = new HashSet<String>(Arrays.asList("S".split("")));
    private static String CUSTOM_OPTION_START = "J";
    private static String CUSTOM_OPTION_STARTER = String.format("-%s", CUSTOM_OPTION_START);

    public static int extractSshCommandLineFromExecuteCommand(String[] values) {
        int i = 1;
        if (values == null || values.length < 2) {
            throw new IllegalArgumentException("Not enough arguments!");
        }
        if (!values[1].startsWith("-")) {
            return i;
        }
        while (i < values.length && i + 1 <= values.length - 1) {
            String option = values[i];
            String optionStripped = SshClientOptionsExtractor.stripOption(option);
            String optionValue = values[i + 1];
            if (option.startsWith("-") && SSH_SINGLE_OPTIONS.contains(optionStripped)) {
                ++i;
                continue;
            }
            if (option.startsWith(CUSTOM_OPTION_STARTER) && option.length() == 2 && SSH_CUSTOM_SINGLE_OPTIONS.contains(optionStripped)) {
                ++i;
                continue;
            }
            if (option.startsWith("-") && SSH_DOUBLE_OPTIONS.contains(optionStripped)) {
                i += 2;
                continue;
            }
            if (option.startsWith(CUSTOM_OPTION_STARTER) && option.length() == 2 && SSH_CUSTOM_DOUBLE_OPTIONS.contains(optionStripped)) {
                i += 2;
                continue;
            }
            if (!option.startsWith("-") && !optionValue.startsWith("-")) break;
            throw new IllegalStateException("Cannot tokenize options.");
        }
        return i;
    }

    private static String stripOption(String option) {
        if (option.startsWith(CUSTOM_OPTION_STARTER)) {
            return option.replaceAll(CUSTOM_OPTION_STARTER, "");
        }
        return option.replaceAll("-", "");
    }
}

