/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClient;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.AbstractCommandTask;
import com.sshtools.client.tasks.ShellTask;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.IOUtils;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.server.vsession.commands.sftp.SftpClientOptions;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.vsession.commands.ssh.AbstractSshClientCommand;
import com.sshtools.vsession.commands.ssh.CommandUtil;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientOptionsEvaluator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class SshClientCommand
extends AbstractSshClientCommand {
    public SshClientCommand() {
        super("ssh", "Shell", "", "Returns the ssh client shell");
        for (Option option : SftpClientOptions.getOptions()) {
            this.options.addOption(option);
        }
    }

    @Override
    protected void runCommand(SshClient sshClient, SshClientArguments arguments, final VirtualConsole console) {
        if (CommandUtil.isNotEmpty(arguments.getCommand())) {
            String command = arguments.getCommand();
            Connection connection = sshClient.getConnection();
            AbstractCommandTask task = new AbstractCommandTask((SshConnection)connection, command){

                protected void beforeExecuteCommand(SessionChannelNG session) {
                    session.allocatePseudoTerminal(console.getTerminal().getType(), console.getTerminal().getWidth(), console.getTerminal().getHeight());
                }

                protected void onOpenSession(final SessionChannelNG session) throws IOException {
                    console.getSessionChannel().enableRawMode();
                    this.con.addTask(new ConnectionAwareTask(this.con){

                        protected void doTask() throws Throwable {
                            IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream());
                        }
                    });
                    IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
                }
            };
            connection.addTask((ConnectionAwareTask)task);
            task.waitForever();
            console.getSessionChannel().disableRawMode();
            return;
        }
        Connection connection = sshClient.getConnection();
        ShellTask shell = new ShellTask((SshConnection)connection){

            protected void beforeStartShell(SessionChannelNG session) {
                session.allocatePseudoTerminal(console.getTerminal().getType(), console.getTerminal().getWidth(), console.getTerminal().getHeight());
            }

            protected void onOpenSession(final SessionChannelNG session) throws IOException, SshException, ShellTimeoutException {
                console.getSessionChannel().enableRawMode();
                this.con.addTask(new ConnectionAwareTask(this.con){

                    protected void doTask() throws Throwable {
                        IOUtils.copy((InputStream)console.getSessionChannel().getInputStream(), (OutputStream)session.getOutputStream());
                    }
                });
                IOUtils.copy((InputStream)session.getInputStream(), (OutputStream)console.getSessionChannel().getOutputStream());
            }
        };
        connection.addTask((ConnectionAwareTask)shell);
        shell.waitForever();
        console.getSessionChannel().disableRawMode();
        console.println();
    }

    @Override
    protected SshClientArguments generateCommandArguments(CommandLine cli, String[] args) throws IOException, PermissionDeniedException {
        return SshClientOptionsEvaluator.evaluate(cli, args, this.console);
    }
}

