/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class ShellCommandWithOptions
extends ShellCommand {
    private Options options = new Options();

    public ShellCommandWithOptions(String name, String subsystem, String signature, String description, Option ... options) {
        super(name, subsystem, signature, description);
        if (options != null) {
            for (Option option : options) {
                this.options.addOption(option);
            }
        }
    }

    @Override
    public final void run(String[] args, VirtualConsole console) throws IOException, PermissionDeniedException, UsageException {
        CommandLine cli;
        DefaultParser parser = new DefaultParser();
        Options options = this.getOptions();
        if (options == null) {
            options = new Options();
        }
        try {
            cli = parser.parse(options, this.filterArgs(args), !this.hasFixedOptions());
        }
        catch (ParseException e) {
            throw new UsageException(this.getUsage());
        }
        this.run(cli, console);
    }

    protected String[] filterArgs(String[] args) {
        return args;
    }

    public abstract void run(CommandLine var1, VirtualConsole var2) throws IOException, PermissionDeniedException, UsageException;

    public Options getOptions() {
        return this.options;
    }

    public boolean hasFixedOptions() {
        return true;
    }
}

