/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands;

import com.sshtools.server.vsession.CliHelper;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Alias
extends ShellCommand {
    public static Map<String, Map<String, String>> userlist = new HashMap<String, Map<String, String>>();
    public static Map<String, String> predefined = new HashMap<String, String>();

    public Alias() {
        super("alias", "Shell", UsageHelper.build("alias [options] <name=value>...", "-p, --print           Print out existing aliases"), "Set an alias to abbreviate long commands.");
        this.setBuiltIn(true);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        String username = console.getConnection().getUsername();
        if (!userlist.containsKey(username)) {
            userlist.put(username, new HashMap());
        }
        Map<String, String> aliaslist = userlist.get(username);
        if (!CliHelper.hasOption(args, 'p', "print") && args.length > 1) {
            boolean skip = true;
            for (String arg : args) {
                if (skip) {
                    skip = false;
                    continue;
                }
                int idx = arg.indexOf(61);
                if (idx > -1) {
                    String name = arg.substring(0, idx);
                    String value = arg.substring(idx + 1);
                    if (name.equalsIgnoreCase("alias") || name.equalsIgnoreCase("unalias")) {
                        console.println("alias: cannot use '" + name + "' as alias");
                        continue;
                    }
                    aliaslist.put(name, value);
                    continue;
                }
                String value = aliaslist.get(arg);
                if (value == null) {
                    console.println("alias: " + arg + ": not found");
                    continue;
                }
                console.println("alias " + arg + "='" + value + "'");
            }
        } else if (userlist.containsKey(username)) {
            Map<String, String> list = userlist.get(username);
            for (Map.Entry<String, String> entry : list.entrySet()) {
                console.println("alias " + entry.getKey() + "='" + entry.getValue() + "'");
            }
        } else {
            console.println("No aliases set");
        }
    }

    public static void setPredefinedAlias(String alias, String cmd) {
        predefined.put(alias, cmd);
    }

    public static boolean hasAlias(String alias, String username) {
        boolean hasAlias = false;
        if (userlist.containsKey(username)) {
            Map<String, String> list = userlist.get(username);
            hasAlias = list.containsKey(alias);
        }
        return hasAlias || predefined.containsKey(alias);
    }

    public static String getAliasCommand(String alias, String username) {
        if (userlist.containsKey(username)) {
            Map<String, String> list = userlist.get(username);
            return list.get(alias);
        }
        if (predefined.containsKey(alias)) {
            return predefined.get(alias);
        }
        return null;
    }
}

