/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands;

import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.UsageException;
import com.sshtools.server.vsession.UsageHelper;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;

public class Input
extends ShellCommand {
    public Input() {
        super("input", "Shell", UsageHelper.build("input <env> <prompt>"), "Read a line of input from the user and place it into an environment variable");
        this.setBuiltIn(true);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException, UsageException {
        if (args.length < 2) {
            throw new UsageException("You must provde an environment variable name to place the user input into!");
        }
        String val = console.readLine(this.getPrompt(args));
        console.getEnvironment().put(args[1], val);
    }

    private String getPrompt(String[] args) {
        StringBuffer buf = new StringBuffer();
        for (int i = 2; i < args.length; ++i) {
            buf.append(args[i]);
            buf.append(" ");
        }
        return buf.toString();
    }
}

