/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands;

import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;
import java.util.Map;

public class Env
extends ShellCommand {
    public Env() {
        super("set", "Shell", "set <variable>=<value>", "Set an environment variable");
        this.setBuiltIn(true);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        if (args.length == 1) {
            for (Map.Entry<String, Object> entry : console.getEnvironment().entrySet()) {
                console.println((String)entry.getKey() + "=" + this.formatEntryValue(entry));
            }
        } else if (args.length == 2) {
            if (args[1].indexOf("=") > -1) {
                String name = args[1].substring(0, args[1].indexOf("="));
                String string = args[1].substring(args[1].indexOf("=") + 1);
                console.getSessionChannel().setEnvironmentVariable(name, string);
            }
        } else {
            console.println("ERR: Incorrect number of arguments. Use help [command] for signature.");
        }
    }

    protected Object formatEntryValue(Map.Entry<String, Object> entry) {
        if (entry.getValue() == null) {
            return "<null>";
        }
        return entry.getValue();
    }
}

