/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands.sftp;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.vsession.commands.ssh.AbstractSshOptionsEvaluator;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class SftpClientOptionsEvaluator
extends AbstractSshOptionsEvaluator {
    public static SshClientArguments evaluate(CommandLine commandLine, VirtualConsole console) throws IOException, PermissionDeniedException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"The argument list passed as {}", (Object[])new Object[]{commandLine.getArgList()});
            List optionList = Arrays.asList(commandLine.getOptions()).stream().map(option -> String.format("{} -> {}", option.getArgName(), option.getValue())).collect(Collectors.toList());
            Log.debug((String)"The option list passed as {}", (Object[])new Object[]{optionList});
        }
        SshClientArguments arguments = new SshClientArguments();
        SftpClientOptionsEvaluator.parsePort(commandLine, arguments);
        SftpClientOptionsEvaluator.parseLoginName(commandLine, arguments);
        SftpClientOptionsEvaluator.parseIdentityFilename(commandLine, arguments, console);
        SftpClientOptionsEvaluator.parseCiphers(commandLine, arguments);
        SftpClientOptionsEvaluator.parseMacs(commandLine, arguments);
        SftpClientOptionsEvaluator.parseSecurityLevel(commandLine, arguments);
        SftpClientOptionsEvaluator.parseCompression(commandLine, arguments);
        SftpClientOptionsEvaluator.parseDestination(commandLine, arguments);
        return arguments;
    }
}

