/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession.commands;

import com.sshtools.common.ssh.SshConnection;
import com.sshtools.server.vsession.AbstractUUIDCommand;
import com.sshtools.server.vsession.VirtualConsole;
import java.io.IOException;

public class Kill
extends AbstractUUIDCommand {
    public Kill() {
        super("kill", "Shell", "kill [<loginId or processId>]", "Kill a process or login");
        this.setBuiltIn(false);
    }

    @Override
    public void run(String[] args, VirtualConsole console) throws IOException {
        if (args.length < 2) {
            throw new IOException("Not enough arguments.");
        }
        for (int i = 1; i < args.length; ++i) {
            try {
                long pid = Long.parseLong(args[i]);
                console.getShell().killProcess(pid);
                continue;
            }
            catch (NumberFormatException nfe) {
                SshConnection connection = console.getConnection().getConnectionManager().getConnectionById(args[i]);
                if (connection == null) continue;
                connection.disconnect("Killed by " + console.getConnection().getUsername());
            }
        }
    }
}

