/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.AbstractMount;
import org.apache.commons.vfs2.FileSystemOptions;

public class VirtualMountTemplate
extends AbstractMount {
    private AbstractFileFactory<?> actualFileFactory;
    private FileSystemOptions fileSystemOptions;
    private boolean createMountFolder;
    private long lastModified = 0L;

    public VirtualMountTemplate(String mount, String path, AbstractFileFactory<?> actualFileFactory, boolean createMountFolder) {
        super(mount, path, false, false);
        this.actualFileFactory = actualFileFactory;
        this.createMountFolder = createMountFolder;
    }

    public VirtualMountTemplate(String mount, String path, AbstractFileFactory<?> actualFileFactory, boolean createMountFolder, long lastModified) {
        super(mount, path, false, false);
        this.actualFileFactory = actualFileFactory;
        this.createMountFolder = createMountFolder;
        this.lastModified = lastModified;
    }

    public boolean isCreateMountFolder() {
        return this.createMountFolder;
    }

    public AbstractFileFactory<?> getActualFileFactory() {
        return this.actualFileFactory;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public boolean isParentOf(VirtualMountTemplate o2) {
        return o2.getMount().startsWith(this.getMount());
    }

    public boolean isChildOf(VirtualMountTemplate o2) {
        return this.getMount().startsWith(o2.getMount());
    }

    public long lastModified() {
        return this.lastModified;
    }

    public VirtualMountTemplate setUsername(String username) {
        this.username = username;
        return this;
    }

    public VirtualMountTemplate setGroup(String group) {
        this.group = group;
        return this;
    }

    public VirtualMountTemplate setUid(int uid) {
        this.uid = uid;
        return this;
    }

    public VirtualMountTemplate setGid(int gid) {
        this.gid = gid;
        return this;
    }
}

