/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.server;

import com.sshtools.agent.AgentProvider;
import com.sshtools.agent.InMemoryKeyStore;
import com.sshtools.agent.KeyStore;
import com.sshtools.agent.client.AgentSocketType;
import com.sshtools.agent.openssh.OpenSSHConnectionFactory;
import com.sshtools.agent.server.SshAgentAcceptor;
import com.sshtools.agent.server.SshAgentConnection;
import com.sshtools.agent.server.SshAgentConnectionFactory;
import com.sshtools.agent.server.SshAgentTransport;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;

public class SshAgentServer {
    KeyStore keystore;
    SshAgentConnectionFactory connectionFactory;
    SshAgentAcceptor acceptor;

    public SshAgentServer(SshAgentConnectionFactory connectionFactory) {
        this(connectionFactory, new InMemoryKeyStore());
    }

    public SshAgentServer(SshAgentConnectionFactory connectionFactory, KeyStore keystore) {
        this.connectionFactory = connectionFactory;
        this.keystore = keystore;
    }

    public void startListener(SshAgentAcceptor acceptor) throws IOException {
        this.acceptor = acceptor;
        ServerThread t = new ServerThread(acceptor);
        t.start();
    }

    public void startListener(String location, AgentSocketType type) throws IOException {
        AgentProvider l;
        SshAgentAcceptor serverAcceptor = null;
        Iterator<AgentProvider> iterator = ServiceLoader.load(AgentProvider.class, JCEComponentManager.getDefaultInstance().getClassLoader()).iterator();
        while (iterator.hasNext() && (serverAcceptor = (l = iterator.next()).server(location, type)) == null) {
        }
        if (serverAcceptor == null) {
            throw new IOException("No provider available. Do you have maverick-sshagent-jnr-sockets or maverick-sshagent-jdk16-sockets on the classpath?");
        }
        ServerThread t = new ServerThread(serverAcceptor);
        t.start();
    }

    public void startUnixSocketListener(String location) throws IOException {
        this.startListener(location, AgentSocketType.UNIX_DOMAIN);
    }

    public void close() throws IOException {
        Log.info((String)"Agent server is closing down", (Object[])new Object[0]);
        if (this.acceptor != null) {
            this.acceptor.close();
        }
    }

    public static void main(String[] args) throws IOException {
        new SshAgentServer(new OpenSSHConnectionFactory()).startUnixSocketListener("/private/tmp/com.sshtools.agent");
    }

    class ServerThread
    extends Thread {
        SshAgentAcceptor socket;

        public ServerThread(SshAgentAcceptor socket) {
            super("Agent-Server-Thread");
            this.setDaemon(true);
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                SshAgentTransport sock;
                while ((sock = this.socket.accept()) != null) {
                    SshAgentConnection c = SshAgentServer.this.connectionFactory.createConnection(SshAgentServer.this.keystore, sock.getInputStream(), sock.getOutputStream(), sock);
                    Thread t = new Thread(c);
                    t.start();
                }
            }
            catch (IOException e) {
                Log.error((String)"Agent server exited with error", (Throwable)e, (Object[])new Object[0]);
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

