/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.rfc;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;

public class SshAgentPrivateKeyOp
extends AgentMessage {
    SshPublicKey pubkey;
    String operation;
    byte[] data;

    public SshAgentPrivateKeyOp() {
        super(205);
    }

    public SshAgentPrivateKeyOp(SshPublicKey pubkey, String operation, byte[] data) {
        super(205);
        this.pubkey = pubkey;
        this.operation = operation;
        this.data = data;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getOperation() {
        return this.operation;
    }

    public byte[] getOperationData() {
        return this.data;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENT_PRIVATE_KEY_OP";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeString(this.operation);
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.writeBinaryString(this.data);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
        catch (SshException e) {
            throw new InvalidMessageException(e.getMessage(), 13);
        }
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.operation = bar.readString();
            this.pubkey = SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])bar.readBinaryString());
            this.data = bar.readBinaryString();
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }
}

