/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey;

import com.sshtools.common.publickey.KeyGenerator;
import com.sshtools.common.publickey.KeyGeneratorFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import java.io.IOException;
import java.util.ServiceLoader;

public class SshKeyPairGenerator {
    public static final String SSH2_RSA = "ssh-rsa";
    public static final String ECDSA = "ecdsa";
    public static final String ED25519 = "ed25519";
    public static final String ED448 = "ed448";

    public static SshKeyPair generateKeyPair(String algorithm) throws IOException, SshException {
        switch (algorithm) {
            case "ecdsa": {
                return SshKeyPairGenerator.generateKeyPair(algorithm, 256);
            }
            case "ed25519": {
                return SshKeyPairGenerator.generateKeyPair(algorithm, 0);
            }
            case "ed448": {
                return SshKeyPairGenerator.generateKeyPair(algorithm, 0);
            }
            case "ssh-rsa": 
            case "rsa": 
            case "RSA": {
                return SshKeyPairGenerator.generateKeyPair(algorithm, 2048);
            }
        }
        throw new IOException(String.format("Unexpected key algorithm %s", algorithm));
    }

    public static SshKeyPair generateKeyPair(String algorithm, int bits) throws IOException, SshException {
        switch (algorithm) {
            case "ed25519": 
            case "ssh-ed25519": {
                return ComponentManager.getDefaultInstance().generateEd25519KeyPair();
            }
            case "ed448": 
            case "ssh-ed448": {
                return ComponentManager.getDefaultInstance().generateEd448KeyPair();
            }
            case "ecdsa": {
                return ComponentManager.getDefaultInstance().generateEcdsaKeyPair(bits);
            }
            case "ssh-rsa": 
            case "rsa": 
            case "RSA": {
                return ComponentManager.getDefaultInstance().generateRsaKeyPair(bits, 2);
            }
        }
        ComponentFactory generators = new ComponentFactory(JCEComponentManager.getDefaultInstance());
        for (KeyGeneratorFactory s : ServiceLoader.load(KeyGeneratorFactory.class, JCEComponentManager.getDefaultInstance().getClassLoader())) {
            if (!ComponentManager.isDefaultEnabled(KeyGenerator.class, s.getKeys()[0]).orElse(false).booleanValue()) continue;
            generators.add(s);
        }
        return ((KeyGenerator)generators.getInstance(algorithm)).generateKey(bits);
    }
}

