/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.FileVolume;
import com.sshtools.common.files.direct.NioFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.OpenFile;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class NioFile
implements AbstractFile {
    public static final int SSH_FXE_STATVFS_ST_RDONLY = 1;
    public static final int SSH_FXE_STATVFS_ST_NOSUID = 2;
    private Path path;
    private Path home;
    private final NioFileFactory fileFactory;
    private boolean sandbox;

    NioFile(Path path, NioFileFactory fileFactory, Path home, boolean sandbox) throws IOException, PermissionDeniedException {
        if (sandbox && (Files.exists(path, new LinkOption[0]) && !path.toRealPath(new LinkOption[0]).startsWith(home.toRealPath(new LinkOption[0])) || !Files.exists(path, new LinkOption[0]) && !path.startsWith(home.toRealPath(new LinkOption[0])))) {
            throw new PermissionDeniedException(MessageFormat.format("You cannot access paths outside of the sandbox path {0}. The path {1} was requested.", home.toRealPath(new LinkOption[0]), path));
        }
        this.home = home;
        this.fileFactory = fileFactory;
        this.path = path;
        this.sandbox = sandbox;
        if (Files.exists(this.path, new LinkOption[0])) {
            this.getAttributes();
        }
    }

    NioFile(String path, NioFileFactory fileFactory, Path home, boolean sandbox) throws IOException, PermissionDeniedException {
        this(home.resolve(path), fileFactory, home, sandbox);
    }

    @Override
    public boolean existsNoFollowLinks() throws IOException, PermissionDeniedException {
        return Files.exists(this.path, LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    public void linkTo(String target) throws IOException, PermissionDeniedException {
        try {
            Files.createLink(target.startsWith("/") ? this.fileFactory.getFile((String)target).path : this.home.resolve(target), this.path);
        }
        catch (IOException nfe) {
            throw this.translateException(nfe);
        }
    }

    @Override
    public void linkFrom(String target) throws IOException, PermissionDeniedException {
        try {
            Path targetPath = this.fileFactory.getFile((String)target).path;
            if (target.startsWith("/")) {
                Files.createLink(this.path, targetPath);
            } else {
                Path relativeTo = this.path.toAbsolutePath().getParent();
                Files.createLink(this.path, relativeTo.relativize(targetPath));
            }
        }
        catch (IOException nfe) {
            throw this.translateException(nfe);
        }
    }

    @Override
    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        try {
            Files.createSymbolicLink(target.startsWith("/") ? this.fileFactory.getFile((String)target).path : this.home.resolve(target), this.path, new FileAttribute[0]);
        }
        catch (IOException nfe) {
            throw this.translateException(nfe);
        }
    }

    @Override
    public void symlinkFrom(String target) throws IOException, PermissionDeniedException {
        try {
            Path targetPath = this.fileFactory.getFile((String)target).path;
            if (target.startsWith("/")) {
                Files.createSymbolicLink(this.path, targetPath, new FileAttribute[0]);
            } else {
                Path relativeTo = this.path.toAbsolutePath().getParent();
                Files.createSymbolicLink(this.path, relativeTo.relativize(targetPath), new FileAttribute[0]);
            }
        }
        catch (IOException nfe) {
            throw this.translateException(nfe);
        }
    }

    @Override
    public String readSymbolicLink() throws IOException, PermissionDeniedException {
        try {
            return Files.readSymbolicLink(this.path).toString();
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public String getName() {
        return this.path.getFileName() == null ? "" : this.path.getFileName().toString();
    }

    @Override
    public InputStream getInputStream() throws IOException, PermissionDeniedException {
        try {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public boolean exists() throws IOException, PermissionDeniedException {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
            ArrayList<NioFile> l = new ArrayList<NioFile>();
            for (Path p : stream) {
                l.add(new NioFile(p, this.fileFactory, this.home, this.sandbox));
            }
            List list = Collections.unmodifiableList(l);
            return list;
        }
    }

    @Override
    public String getAbsolutePath() throws IOException, PermissionDeniedException {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public AbstractFile getParentFile() throws IOException, PermissionDeniedException {
        return this.path.getParent() == null ? null : new NioFile(this.path.getParent(), this.fileFactory, this.home, this.sandbox);
    }

    @Override
    public boolean isDirectory() throws IOException, PermissionDeniedException {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isFile() throws IOException, PermissionDeniedException {
        return Files.isRegularFile(this.path, new LinkOption[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException, PermissionDeniedException {
        try {
            return Files.newOutputStream(this.path, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public boolean isHidden() throws IOException, PermissionDeniedException {
        return Files.isHidden(this.path);
    }

    @Override
    public boolean createFolder() throws PermissionDeniedException, IOException {
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isReadable() throws IOException, PermissionDeniedException {
        return !Files.exists(this.path, new LinkOption[0]) && (this.path.getParent() == null || Files.isReadable(this.path.getParent())) || Files.isReadable(this.path);
    }

    @Override
    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        try {
            if (src instanceof NioFile) {
                Files.copy(((NioFile)src).path, this.path, new CopyOption[0]);
            } else {
                AbstractFile.super.copyFrom(src);
            }
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        try {
            if (target instanceof NioFile) {
                Files.move(this.path, ((NioFile)target).path, new CopyOption[0]);
            } else {
                AbstractFile.super.moveTo(target);
            }
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public boolean delete(boolean recursive) throws IOException, PermissionDeniedException {
        if (recursive) {
            return IOUtils.silentRecursiveDelete((Path)this.path, (FileVisitOption[])new FileVisitOption[0]);
        }
        try {
            Files.delete(this.path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public SftpFileAttributes getAttributesNoFollowLinks() throws FileNotFoundException, IOException, PermissionDeniedException {
        if (!this.existsNoFollowLinks()) {
            throw new FileNotFoundException();
        }
        return this.doGetAttributes();
    }

    @Override
    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException {
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        return this.doGetAttributes();
    }

    @Override
    public OpenFile open(final UnsignedInteger32 flags, final Optional<UnsignedInteger32> accessFlags, final byte[] handle) throws IOException, PermissionDeniedException {
        long flagVal = flags.longValue();
        LinkedHashSet<StandardOpenOption> opts = new LinkedHashSet<StandardOpenOption>();
        if (accessFlags.isPresent()) {
            throw new UnsupportedOperationException();
        }
        if ((flagVal & 2L) != 0L) {
            opts.add(StandardOpenOption.WRITE);
        }
        if ((flagVal & 1L) != 0L) {
            opts.add(StandardOpenOption.READ);
        }
        if ((flagVal & 4L) != 0L) {
            opts.add(StandardOpenOption.APPEND);
        }
        if ((flagVal & 0x10L) != 0L) {
            opts.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if ((flagVal & 0x20L) != 0L) {
            opts.add(StandardOpenOption.CREATE_NEW);
        } else if ((flagVal & 8L) != 0L) {
            opts.add(StandardOpenOption.CREATE);
        }
        final boolean textMode = (flagVal & 0x40L) != 0L;
        final FileChannel channel = (FileChannel)Files.newByteChannel(this.path, opts.toArray(new OpenOption[0]));
        return new OpenFile(){
            private int lockFlags = -1;

            @Override
            public Optional<UnsignedInteger32> getAccessFlags() {
                return accessFlags;
            }

            @Override
            public void lock(long offset, long length, int lockFlags) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void unlock(long offset, long length) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int lockFlags() {
                return this.lockFlags;
            }

            @Override
            public void write(byte[] data, int off, int len) throws IOException, PermissionDeniedException {
                channel.write(ByteBuffer.wrap(data, off, len));
            }

            @Override
            public void seek(long longValue) throws IOException {
                channel.position(longValue);
            }

            @Override
            public int read(byte[] buf, int start, int numBytesToRead) throws IOException, PermissionDeniedException {
                return channel.read(ByteBuffer.wrap(buf, start, numBytesToRead));
            }

            @Override
            public void processEvent(Event evt) {
                evt.addAttribute("ABSTRACT_FILE", NioFile.this);
                evt.addAttribute("ABSTRACT_FILE_RAF", channel);
            }

            @Override
            public boolean isTextMode() {
                return textMode;
            }

            @Override
            public byte[] getHandle() {
                return handle;
            }

            @Override
            public UnsignedInteger32 getFlags() {
                return flags;
            }

            @Override
            public long getFilePointer() throws IOException {
                return channel.position();
            }

            @Override
            public AbstractFile getFile() {
                return NioFile.this;
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
    }

    protected SftpFileAttributes doGetAttributes() throws FileNotFoundException, IOException {
        try {
            Path file = this.path;
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            SftpFileAttributes.SftpFileAttributesBuilder bldr = SftpFileAttributes.SftpFileAttributesBuilder.ofType(this.getFileType(attr), "UTF-8");
            try {
                bldr.withSize(new UnsignedInteger64(attr.size()));
                try {
                    PosixFileAttributes posix = Files.readAttributes(file, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    bldr.withGroup(posix.group().getName());
                    bldr.withUsername(posix.owner().getName());
                    bldr.withLastAccessTime(posix.lastAccessTime());
                    bldr.withLastModifiedTime(posix.lastModifiedTime());
                    bldr.withPermissions(posix.permissions());
                    return bldr.build();
                }
                catch (IOException | UnsupportedOperationException posix) {
                    bldr.withLastAccessTime(attr.lastAccessTime());
                    bldr.withLastModifiedTime(attr.lastModifiedTime());
                    bldr.withCreateTime(attr.creationTime());
                    try {
                        Path filename;
                        DosFileAttributes dos = Files.readAttributes(file, DosFileAttributes.class, new LinkOption[0]);
                        PosixPermissions.PosixPermissionsBuilder permsBldr = PosixPermissions.PosixPermissionsBuilder.create();
                        permsBldr.withAllRead();
                        if (!dos.isReadOnly()) {
                            permsBldr.withAllWrite();
                        }
                        if ((filename = this.path.getFileName()) != null && (filename.toString().endsWith(".exe") || filename.toString().endsWith(".com") || filename.toString().endsWith(".cmd"))) {
                            permsBldr.withAllExecute();
                        }
                        bldr.withPermissions(permsBldr.build());
                    }
                    catch (IOException | UnsupportedOperationException exception) {}
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return bldr.build();
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public long lastModified() throws IOException, PermissionDeniedException {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public long length() throws IOException, PermissionDeniedException {
        try {
            return Files.size(this.path);
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public boolean isWritable() throws IOException, PermissionDeniedException {
        return Files.exists(this.path, new LinkOption[0]) && Files.isWritable(this.path) || !Files.exists(this.path, new LinkOption[0]) && (this.path.getParent() == null || Files.isWritable(this.path.getParent()));
    }

    @Override
    public boolean createNewFile() throws PermissionDeniedException, IOException {
        try {
            Files.createFile(this.path, new FileAttribute[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void truncate() throws PermissionDeniedException, IOException {
        Files.deleteIfExists(this.path);
        Files.createFile(this.path, new FileAttribute[0]);
    }

    @Override
    public void setAttributes(SftpFileAttributes attrs) throws IOException {
        block13: {
            try {
                BasicFileAttributeView basicView = Files.getFileAttributeView(this.path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                basicView.setTimes(attrs.lastModifiedTimeOr().orElse(null), attrs.lastAccessTimeOr().orElse(null), attrs.createTimeOr().orElse(null));
                if (attrs.hasSize() && attrs.size().longValue() != Files.size(this.path)) {
                    try (SeekableByteChannel chan = Files.newByteChannel(this.path, StandardOpenOption.WRITE);){
                        chan.truncate(attrs.size().longValue());
                    }
                }
                attrs.usernameOr().ifPresentOrElse(u -> {
                    try {
                        Files.setOwner(this.path, this.path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName((String)u));
                    }
                    catch (IOException | IllegalArgumentException | UnsupportedOperationException exception) {
                        // empty catch block
                    }
                }, () -> attrs.uidOr().ifPresent(u -> {
                    try {
                        Files.setOwner(this.path, this.path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(String.valueOf(u)));
                    }
                    catch (IOException | IllegalArgumentException | UnsupportedOperationException exception) {
                        // empty catch block
                    }
                }));
                attrs.groupOr().ifPresentOrElse(g -> {
                    try {
                        Files.setAttribute(this.path, "posix:group", this.path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByGroupName((String)g), new LinkOption[0]);
                    }
                    catch (IOException | IllegalArgumentException | UnsupportedOperationException exception) {
                        // empty catch block
                    }
                }, () -> attrs.uidOr().ifPresent(g -> {
                    try {
                        Files.setAttribute(this.path, "posix:group", this.path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByGroupName(String.valueOf(g)), new LinkOption[0]);
                    }
                    catch (IOException | IllegalArgumentException | UnsupportedOperationException exception) {
                        // empty catch block
                    }
                }));
                PosixPermissions newPerms = attrs.permissions();
                if (newPerms.equals(PosixPermissions.EMPTY)) break block13;
                Set<PosixFilePermission> current = null;
                try {
                    current = Files.getPosixFilePermissions(this.path, new LinkOption[0]);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (current != null && !Objects.equals(current, newPerms.asPermissions())) {
                    Files.setPosixFilePermissions(this.path, newPerms.asPermissions());
                }
            }
            catch (IOException ioe) {
                throw this.translateException(ioe);
            }
        }
    }

    @Override
    public String getCanonicalPath() throws IOException, PermissionDeniedException {
        try {
            return this.path.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    public AbstractFileRandomAccess openFile(boolean writeAccess) throws IOException, PermissionDeniedException {
        final SeekableByteChannel channel = this.createChannel(writeAccess);
        return new AbstractFileRandomAccess(){

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                channel.write(ByteBuffer.wrap(buf, off, len));
            }

            @Override
            public void setLength(long length) throws IOException {
                channel.truncate(length);
            }

            @Override
            public void seek(long position) throws IOException {
                channel.position(position);
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return channel.read(ByteBuffer.wrap(buf, off, len));
            }

            @Override
            public long getFilePointer() throws IOException {
                return channel.position();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }

            @Override
            public int read() throws IOException {
                byte[] tmp = new byte[1];
                int c = this.read(tmp, 0, 1);
                if (c == 1) {
                    return tmp[0] & 0xFF;
                }
                return c;
            }
        };
    }

    private SeekableByteChannel createChannel(boolean writeAccess) throws IOException {
        try {
            SeekableByteChannel channel = null;
            channel = writeAccess ? Files.newByteChannel(this.path, StandardOpenOption.WRITE, StandardOpenOption.CREATE) : Files.newByteChannel(this.path, StandardOpenOption.READ);
            return channel;
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        try {
            return Files.newOutputStream(this.path, StandardOpenOption.APPEND);
        }
        catch (IOException ioe) {
            throw this.translateException(ioe);
        }
    }

    @Override
    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        return new NioFile(this.path.resolve(child), this.fileFactory, this.home, this.sandbox);
    }

    public AbstractFileFactory<NioFile> getFileFactory() {
        return this.fileFactory;
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NioFile other = (NioFile)obj;
        return Objects.equals(this.path, other.path);
    }

    public String toString() {
        return this.path.toString();
    }

    @Override
    public FileVolume getVolume() throws IOException {
        final FileStore nativeStore = this.path.getFileSystem().provider().getFileStore(this.path);
        return new FileVolume(){

            @Override
            public long userFreeInodes() {
                return this.freeInodes();
            }

            @Override
            public long userFreeBlocks() {
                try {
                    return nativeStore.getUsableSpace() / this.blockSize();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public long underlyingBlockSize() {
                return this.blockSize();
            }

            @Override
            public long totalInodes() {
                return 0L;
            }

            @Override
            public long maxFilenameLength() {
                return 255L;
            }

            @Override
            public long id() {
                if (((NioFileFactory)NioFile.this.getFileFactory()).isSandboxed()) {
                    return Integer.toUnsignedLong(((NioFileFactory)NioFile.this.getFileFactory()).home().hashCode());
                }
                return Integer.toUnsignedLong(nativeStore.name().hashCode());
            }

            @Override
            public long freeInodes() {
                return 0L;
            }

            @Override
            public long freeBlocks() {
                try {
                    return nativeStore.getUnallocatedSpace() / this.blockSize();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public long flags() {
                return nativeStore.isReadOnly() ? 1L : 0L;
            }

            @Override
            public long blocks() {
                try {
                    return nativeStore.getTotalSpace() / this.blockSize();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public long blockSize() {
                try {
                    return nativeStore.getBlockSize();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    private int getFileType(BasicFileAttributes attr) {
        if (attr.isSymbolicLink()) {
            return 3;
        }
        if (attr.isOther()) {
            return 4;
        }
        if (attr.isDirectory()) {
            return 2;
        }
        if (attr.isRegularFile()) {
            return 1;
        }
        return 5;
    }

    private IOException translateException(IOException nfe) throws IOException {
        if (nfe instanceof NoSuchFileException) {
            return new FileNotFoundException(((NoSuchFileException)nfe).getFile());
        }
        return nfe;
    }
}

