/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.events;

import com.sshtools.common.events.EventObject;
import java.util.HashMap;
import java.util.Map;

public class Event
extends EventObject {
    private final int id;
    private final boolean state;
    private final Map<String, Object> eventAttributes = new HashMap<String, Object>();

    public Event(Object source, int id, boolean state) {
        super(source);
        this.id = id;
        this.state = state;
    }

    public Event(Object source, int id, Throwable error) {
        super(source);
        this.id = id;
        boolean bl = this.state = error == null;
        if (error != null) {
            this.addAttribute("THROWABLE", error);
        }
    }

    public int getId() {
        return this.id;
    }

    public boolean getState() {
        return this.state;
    }

    public Object getAttribute(String key) {
        return this.eventAttributes.get(key);
    }

    public String getAllAttributes() {
        StringBuffer buff = new StringBuffer();
        for (String key : this.eventAttributes.keySet()) {
            Object value = this.eventAttributes.get(key);
            buff.append("|\r\n");
            buff.append(key);
            buff.append(" = ");
            if (value == null) continue;
            buff.append(value.toString());
        }
        return buff.toString();
    }

    public String logAttributes() {
        StringBuffer buff = new StringBuffer();
        for (String key : this.eventAttributes.keySet()) {
            Object value = this.eventAttributes.get(key);
            if (buff.length() > 0) {
                buff.append(" ");
            }
            buff.append(key);
            buff.append("=");
            buff.append(String.valueOf(value));
        }
        return buff.toString();
    }

    public Event addAttribute(String key, Object value) {
        this.eventAttributes.put(key, value);
        return this;
    }
}

