/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.command;

import com.sshtools.common.command.AbstractExecutableCommand;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.util.IOStreamConnector;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Vector;

public class NativeExecutableCommand
extends AbstractExecutableCommand {
    Process process;
    String[] commandLine;
    String[] env;
    ProcessThread thread;
    int exitValue = Integer.MIN_VALUE;

    @Override
    public void onStart() {
        this.thread.start();
    }

    @Override
    public int getExitCode() {
        return this.exitValue;
    }

    @Override
    public boolean createProcess(String[] commandLine, Map<String, String> environment) {
        if (commandLine.length == 0) {
            return false;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Creating native process: {}", (Object[])new Object[]{commandLine[0]});
        }
        this.commandLine = commandLine;
        Vector<CallSite> tmp = new Vector<CallSite>();
        if (environment != null) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                tmp.add((CallSite)((Object)(entry.getKey().toString() + "=" + entry.getValue().toString())));
            }
        }
        this.env = new String[tmp.size()];
        tmp.copyInto(this.env);
        try {
            this.process = Runtime.getRuntime().exec(commandLine, this.env);
            this.thread = new ProcessThread();
            this.session.addEventListener(new ChannelEventListener(){

                @Override
                public void onChannelDataIn(Channel channel, ByteBuffer data) {
                    byte[] tmp = new byte[data.remaining()];
                    data.get(tmp);
                    try {
                        NativeExecutableCommand.this.process.getOutputStream().write(tmp);
                        NativeExecutableCommand.this.process.getOutputStream().flush();
                    }
                    catch (IOException e) {
                        Log.error((String)"Faild to write to process", (Throwable)e, (Object[])new Object[0]);
                        NativeExecutableCommand.this.session.close();
                    }
                }
            });
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public void kill() {
        this.process.destroy();
    }

    class ProcessThread
    extends Thread {
        IOStreamConnector stdout;
        IOStreamConnector stderr;

        ProcessThread() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    Log.info((String)"Starting reading I/O", (Object[])new Object[0]);
                    this.stdout = new IOStreamConnector(NativeExecutableCommand.this.process.getInputStream(), NativeExecutableCommand.this.getOutputStream());
                    this.stderr = new IOStreamConnector(NativeExecutableCommand.this.process.getErrorStream(), NativeExecutableCommand.this.getOutputStream());
                    NativeExecutableCommand.this.exitValue = NativeExecutableCommand.this.process.waitFor();
                    Log.info((String)"Command exited with {}", (Object[])new Object[]{NativeExecutableCommand.this.exitValue});
                }
                catch (Throwable ex) {
                    if (!Log.isDebugEnabled()) break block2;
                    Log.debug((String)"Native process transfer thread failed", (Throwable)ex, (Object[])new Object[0]);
                }
            }
        }
    }
}

