/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.AbstractAuthenticationProtocol;
import com.sshtools.common.auth.AuthenticationMechanism;
import com.sshtools.common.auth.AuthenticationMechanismFactory;
import com.sshtools.common.auth.Authenticator;
import com.sshtools.common.auth.KeyboardInteractiveAuthentication;
import com.sshtools.common.auth.KeyboardInteractiveAuthenticationProvider;
import com.sshtools.common.auth.KeyboardInteractiveProvider;
import com.sshtools.common.auth.PasswordAuthentication;
import com.sshtools.common.auth.PasswordAuthenticationProvider;
import com.sshtools.common.auth.PasswordKeyboardInteractiveProvider;
import com.sshtools.common.auth.PublicKeyAuthentication;
import com.sshtools.common.auth.PublicKeyAuthenticationProvider;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.sshd.AbstractServerTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultAuthenticationMechanismFactory<C extends Context>
implements AuthenticationMechanismFactory<C> {
    protected Set<String> required = new HashSet<String>();
    protected Set<String> supportedMechanisms = new HashSet<String>();
    protected List<PasswordAuthenticationProvider> passwordProviders = new ArrayList<PasswordAuthenticationProvider>();
    protected List<PublicKeyAuthenticationProvider> publickeyProviders = new ArrayList<PublicKeyAuthenticationProvider>();
    protected List<KeyboardInteractiveAuthenticationProvider> keyboardInteractiveProviders = new ArrayList<KeyboardInteractiveAuthenticationProvider>();

    public void addRequiredAuthentication(String req) {
        if (!this.supportedMechanisms.contains(req)) {
            throw new IllegalArgumentException(String.format("%s is not a supported authentication mechanism", req));
        }
        this.required.add(req);
    }

    public void removeRequiredAuthentication(String req) {
        if (!this.supportedMechanisms.contains(req)) {
            throw new IllegalArgumentException(String.format("%s is not a supported authentication mechanism", req));
        }
        this.required.remove(req);
    }

    public void addPasswordAuthenticationProvider(PasswordAuthenticationProvider provider) {
        this.passwordProviders.add(provider);
        this.supportedMechanisms.add("password");
        this.supportedMechanisms.add("keyboard-interactive");
    }

    public void removePasswordAuthenticationProvider(PasswordAuthenticationProvider provider) {
        this.passwordProviders.remove(provider);
        if (this.passwordProviders.size() == 0) {
            this.supportedMechanisms.remove("password");
        }
    }

    public void addPublicKeyAuthenticationProvider(PublicKeyAuthenticationProvider provider) {
        this.publickeyProviders.add(provider);
        this.supportedMechanisms.add("publickey");
    }

    public void removePublicKeyAuthenticationProvider(PublicKeyAuthenticationProvider provider) {
        this.publickeyProviders.remove(provider);
        if (this.publickeyProviders.size() == 0) {
            this.supportedMechanisms.remove("publickey");
        }
    }

    public void addKeyboardInteractiveProvider(KeyboardInteractiveAuthenticationProvider provider) {
        this.keyboardInteractiveProviders.add(provider);
        this.supportedMechanisms.add("keyboard-interactive");
    }

    public void removeKeyboardInteractiveProvider(KeyboardInteractiveAuthenticationProvider provider) {
        this.keyboardInteractiveProviders.remove(provider);
    }

    @Override
    public void addProvider(Authenticator provider) {
        if (provider instanceof PasswordAuthenticationProvider) {
            this.addPasswordAuthenticationProvider((PasswordAuthenticationProvider)provider);
        } else if (provider instanceof PublicKeyAuthenticationProvider) {
            this.addPublicKeyAuthenticationProvider((PublicKeyAuthenticationProvider)provider);
        } else if (provider instanceof KeyboardInteractiveAuthenticationProvider) {
            this.addKeyboardInteractiveProvider((KeyboardInteractiveAuthenticationProvider)provider);
        } else {
            throw new IllegalArgumentException(provider.getClass().getName() + " is not a supported AuthenticationProvider");
        }
    }

    @Override
    public AuthenticationMechanism createInstance(String name, AbstractServerTransport<C> transport, AbstractAuthenticationProtocol<C> authentication, SshConnection con) throws UnsupportedChannelException {
        if (name.equals("password")) {
            return new PasswordAuthentication<C>(transport, authentication, con, this.getPasswordAuthenticationProviders(con));
        }
        if (name.equals("publickey")) {
            return new PublicKeyAuthentication<C>(transport, authentication, con, this.getPublicKeyAuthenticationProviders(con));
        }
        if (name.equals("keyboard-interactive")) {
            return new KeyboardInteractiveAuthentication<C>(transport, authentication, con, this.getKeyboardInteractiveProviders(con));
        }
        throw new UnsupportedChannelException();
    }

    public KeyboardInteractiveAuthenticationProvider[] getKeyboardInteractiveProviders(SshConnection con) {
        if (this.keyboardInteractiveProviders.size() == 0) {
            return new KeyboardInteractiveAuthenticationProvider[]{new KeyboardInteractiveAuthenticationProvider(){

                @Override
                public KeyboardInteractiveProvider createInstance(SshConnection con) {
                    return new PasswordKeyboardInteractiveProvider(DefaultAuthenticationMechanismFactory.this.passwordProviders.toArray(new PasswordAuthenticationProvider[0]), con);
                }
            }};
        }
        return this.keyboardInteractiveProviders.toArray(new KeyboardInteractiveAuthenticationProvider[0]);
    }

    @Override
    public String[] getRequiredMechanisms(SshConnection con) {
        return this.required.toArray(new String[0]);
    }

    @Override
    public String[] getSupportedMechanisms() {
        return this.supportedMechanisms.toArray(new String[0]);
    }

    public PublicKeyAuthenticationProvider[] getPublicKeyAuthenticationProviders(SshConnection con) {
        return this.publickeyProviders.toArray(new PublicKeyAuthenticationProvider[0]);
    }

    public PasswordAuthenticationProvider[] getPasswordAuthenticationProviders(SshConnection con) {
        return this.passwordProviders.toArray(new PasswordAuthenticationProvider[0]);
    }

    @Override
    public Authenticator[] getProviders(String name, SshConnection con) {
        if (name.equals("password")) {
            return this.getPasswordAuthenticationProviders(con);
        }
        if (name.equals("publickey")) {
            return this.getPublicKeyAuthenticationProviders(con);
        }
        if (name.equals("keyboard-interactive")) {
            return this.getKeyboardInteractiveProviders(con);
        }
        throw new IllegalArgumentException("Unknown provider type");
    }

    @Override
    public void addProviders(Collection<Authenticator> authenticators) {
        for (Authenticator authenticator : authenticators) {
            this.addProvider(authenticator);
        }
    }

    @Override
    public boolean isSupportedMechanism(String method) {
        return this.supportedMechanisms.contains(method);
    }
}

