/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractSftpExtension;
import com.sshtools.common.util.ByteArrayReader;
import java.io.IOException;

public class CopyFileSftpExtension
extends AbstractSftpExtension {
    public static final String EXTENSION_NAME = "copy-file";

    protected CopyFileSftpExtension() {
        super(EXTENSION_NAME, false);
    }

    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        try {
            String source = msg.readString();
            String destination = msg.readString();
            boolean overwrite = msg.readBoolean();
            AbstractFileSystem fs = sftp.getFileSystem();
            fs.copyFile(source, destination, overwrite);
            sftp.sendStatusMessage(requestId, 0, "The copy-file operation completed.");
        }
        catch (IOException e) {
            sftp.sendStatusMessage(requestId, 4, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            sftp.sendStatusMessage(requestId, 3, e.getMessage());
        }
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
    }
}

