/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.nio;

import com.sshtools.common.nio.IdleStateListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IdleStateManager {
    Map<IdleStateListener, Long> listeners = new ConcurrentHashMap<IdleStateListener, Long>(50, 0.9f, 1);
    int numSecondsBeforeIdle;
    int servicePeriodSeconds;
    int numInactiveServicesPeriodsPerIdle;
    long lastService = 0L;
    boolean servicing = false;

    public IdleStateManager(int servicePeriodSeconds, int numInactiveServicesPeriodsPerIdle) {
        this.servicePeriodSeconds = servicePeriodSeconds;
        this.numInactiveServicesPeriodsPerIdle = numInactiveServicesPeriodsPerIdle;
    }

    public synchronized void reset(IdleStateListener obj) {
        if (this.listeners.containsKey(obj)) {
            this.listeners.put(obj, new Long(System.currentTimeMillis()));
        }
    }

    public synchronized void register(IdleStateListener obj) {
        this.listeners.put(obj, new Long(System.currentTimeMillis()));
    }

    public synchronized void remove(IdleStateListener obj) {
        if (!this.servicing) {
            this.listeners.remove(obj);
        }
    }

    public boolean isReady() {
        return (System.currentTimeMillis() - this.lastService) / 1000L >= (long)this.servicePeriodSeconds;
    }

    public synchronized void service() {
        this.lastService = System.currentTimeMillis();
        this.servicing = true;
        Iterator<Map.Entry<IdleStateListener, Long>> it = this.listeners.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IdleStateListener, Long> entry = it.next();
            long start = entry.getValue();
            long current = System.currentTimeMillis();
            long elasped = (current - start) / 1000L;
            if (elasped < (long)(this.servicePeriodSeconds * this.numInactiveServicesPeriodsPerIdle) || !entry.getKey().idle()) continue;
            it.remove();
        }
        this.servicing = false;
    }
}

