/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileAdapter;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusEventException;
import com.sshtools.common.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;

public class SpaceRestrictedFileFactoryAdapter
implements AbstractFileFactory<SpaceRestrictedAbstractFile> {
    AbstractFileFactory<?> fileFactory;
    long maximumSize;

    public SpaceRestrictedFileFactoryAdapter(AbstractFileFactory<?> fileFactory, long maximumSize) {
        this.fileFactory = fileFactory;
        this.maximumSize = maximumSize;
    }

    @Override
    public SpaceRestrictedAbstractFile getFile(String path) throws PermissionDeniedException, IOException {
        return new SpaceRestrictedAbstractFile((AbstractFile)this.fileFactory.getFile(path));
    }

    @Override
    public Event populateEvent(Event evt) {
        return evt;
    }

    @Override
    public SpaceRestrictedAbstractFile getDefaultPath() throws PermissionDeniedException, IOException {
        return new SpaceRestrictedAbstractFile((AbstractFile)this.fileFactory.getDefaultPath());
    }

    long getCurrentSize(AbstractFile file) throws IOException, PermissionDeniedException {
        long size = 0L;
        if (file.isDirectory()) {
            for (AbstractFile dir : file.getChildren()) {
                size += this.getCurrentSize(dir);
            }
        } else {
            return file.length();
        }
        return size;
    }

    static class RestrictedSizeOutputStream
    extends OutputStream {
        long restrictedSize;
        long bytesWritten = 0L;
        OutputStream out;

        RestrictedSizeOutputStream(OutputStream out, long restrictedSize) {
            this.out = out;
            this.restrictedSize = restrictedSize;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.restrictedSize > 0L && this.bytesWritten + (long)len > this.restrictedSize) {
                throw new SftpStatusEventException(15, "Out of quota disk space [" + IOUtils.toByteSize((double)this.restrictedSize) + "]");
            }
            this.out.write(b, off, len);
            this.bytesWritten += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.restrictedSize > 0L && this.bytesWritten + 1L > this.restrictedSize) {
                throw new SftpStatusEventException(15, "Out of quota disk space [" + IOUtils.toByteSize((double)this.restrictedSize) + "]");
            }
            this.out.write(b);
            ++this.bytesWritten;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    class SpaceRestrictedAbstractFile
    extends AbstractFileAdapter {
        public SpaceRestrictedAbstractFile(AbstractFile file) {
            super(file);
        }

        @Override
        public boolean supportsRandomAccess() {
            return false;
        }

        @Override
        public OutputStream getOutputStream() throws IOException, PermissionDeniedException {
            return new RestrictedSizeOutputStream(super.getOutputStream(), SpaceRestrictedFileFactoryAdapter.this.maximumSize - SpaceRestrictedFileFactoryAdapter.this.getCurrentSize(SpaceRestrictedFileFactoryAdapter.this.getDefaultPath()));
        }

        @Override
        public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
            return new RestrictedSizeOutputStream(super.getOutputStream(append), SpaceRestrictedFileFactoryAdapter.this.maximumSize - SpaceRestrictedFileFactoryAdapter.this.getCurrentSize(SpaceRestrictedFileFactoryAdapter.this.getDefaultPath()) - (append ? this.length() : 0L));
        }
    }
}

