/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.AbstractAuthenticationProtocol;
import com.sshtools.common.auth.AuthenticationMechanism;
import com.sshtools.common.auth.PasswordAuthenticationProvider;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.sshd.AbstractServerTransport;
import com.sshtools.common.util.ByteArrayReader;
import java.io.IOException;

public class PasswordAuthentication<C extends Context>
implements AuthenticationMechanism {
    static final int SSH_MSG_PASSWORD_CHANGE_REQ = 60;
    AbstractServerTransport<C> transport;
    SshConnection con;
    PasswordAuthenticationProvider[] providers;
    AbstractAuthenticationProtocol<C> authentication;
    String username;
    String service;
    public static final String AUTHENTICATION_METHOD = "password";

    public PasswordAuthentication() {
    }

    public PasswordAuthentication(AbstractServerTransport<C> transport, AbstractAuthenticationProtocol<C> authentication, SshConnection con, PasswordAuthenticationProvider[] providers) {
        this.transport = transport;
        this.authentication = authentication;
        this.con = con;
        this.providers = providers;
    }

    public boolean hasProviders() {
        return this.providers != null && this.providers.length > 0;
    }

    @Override
    public String getMethod() {
        return AUTHENTICATION_METHOD;
    }

    @Override
    public boolean startRequest(String username, byte[] msg) throws IOException {
        this.transport.addTask(ExecutorOperationSupport.EVENTS, new PasswordAuthenticationTask(this.con, username, msg));
        return true;
    }

    @Override
    public boolean processMessage(byte[] msg) throws IOException {
        return false;
    }

    class PasswordAuthenticationTask
    extends ConnectionAwareTask {
        String username;
        byte[] msg;

        PasswordAuthenticationTask(SshConnection con, String username, byte[] msg) {
            super(con);
            this.username = username;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doTask() {
            if (!PasswordAuthentication.this.hasProviders()) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Remote requested password authentication but its not currently supported by this configuration.", (Object[])new Object[0]);
                }
                PasswordAuthentication.this.authentication.failedAuthentication();
                return;
            }
            try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                boolean passwordChange = bar.read() != 0;
                String password = bar.readString();
                boolean success = false;
                for (PasswordAuthenticationProvider passwordProvider : PasswordAuthentication.this.providers) {
                    success = passwordChange ? passwordProvider.changePassword(this.con, this.username, password, bar.readString()) : passwordProvider.verifyPassword(this.con, this.username, password);
                    if (success) break;
                }
                if (success) {
                    PasswordAuthentication.this.authentication.completedAuthentication();
                } else {
                    PasswordAuthentication.this.authentication.failedAuthentication();
                }
            }
        }
    }
}

