/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshKeyFingerprint;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.SshEd25519PublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class SshEd25519PublicKeyJCE
implements SshEd25519PublicKey {
    public static final String ALGORITHM_NAME = "ssh-ed25519";
    PublicKey publicKey;
    byte[] pk;

    public SshEd25519PublicKeyJCE() {
    }

    @Override
    public SecurityLevel getSecurityLevel() {
        return SecurityLevel.PARANOID;
    }

    @Override
    public int getPriority() {
        return 9999;
    }

    public SshEd25519PublicKeyJCE(byte[] pk) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchProviderException {
        this.pk = pk;
        this.loadPublicKey(pk);
    }

    private void loadPublicKey(byte[] pk) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchProviderException {
        KeyFactory keyFactory = KeyFactory.getInstance("Ed25519", "BC");
        SubjectPublicKeyInfo pubKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), pk);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyInfo.getEncoded());
        this.publicKey = keyFactory.generatePublic(x509KeySpec);
    }

    public SshEd25519PublicKeyJCE(PublicKey pub) {
        this.publicKey = pub;
    }

    @Override
    public void init(byte[] blob, int start, int len) throws SshException {
        try (ByteArrayReader bar = new ByteArrayReader(blob, start, len);){
            String name = bar.readString();
            if (!name.equals(ALGORITHM_NAME)) {
                throw new SshException("The encoded key is not ed25519", 5);
            }
            byte[] pub = bar.readBinaryString();
            this.loadPublicKey(pub);
        }
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getEncodingAlgorithm() {
        return this.getAlgorithm();
    }

    @Override
    public int getBitLength() {
        return 256;
    }

    @Override
    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getAlgorithm());
            baw.writeBinaryString(this.decodeJCEKey());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] decodeJCEKey() {
        ASN1InputStream asn = new ASN1InputStream(this.publicKey.getEncoded());
        try {
            DLSequence id = (DLSequence)asn.readObject();
            DERBitString raw = (DERBitString)id.getObjectAt(1).toASN1Primitive();
            byte[] byArray = raw.getBytes();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse ASN output of JCE key", e);
        }
        finally {
            IOUtils.closeStream((InputStream)asn);
        }
    }

    @Override
    public byte[] getA() {
        return this.decodeJCEKey();
    }

    @Override
    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws SshException {
        try {
            try (ByteArrayReader bar = new ByteArrayReader(signature);){
                long count = bar.readInt();
                if (count > 0L && count == (long)this.getSigningAlgorithm().length()) {
                    bar.reset();
                    byte[] sig = bar.readBinaryString();
                    String header = new String(sig);
                    signature = bar.readBinaryString();
                }
            }
            return this.verifyJCESignature(signature, data);
        }
        catch (Exception ex) {
            throw new SshException(16, (Throwable)ex);
        }
    }

    private boolean verifyJCESignature(byte[] signature, byte[] data) throws SshException {
        try {
            Signature sgr = Signature.getInstance("Ed25519", "BC");
            sgr.initVerify(this.publicKey);
            sgr.update(data);
            return sgr.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new SshException(e, 5);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshEd25519PublicKeyJCE) {
            try {
                return ((SshPublicKey)obj).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException ex) {
            return 0;
        }
    }

    @Override
    public String getSigningAlgorithm() {
        return this.getAlgorithm();
    }

    @Override
    public String test() {
        try {
            KeyFactory factory = KeyFactory.getInstance("Ed25519", "BC");
            return factory.getProvider().getName();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey getJCEPublicKey() {
        return this.publicKey;
    }
}

