/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.InvalidHandleException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractSftpExtension;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.MD5Digest;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class AbstractMD5Extension
extends AbstractSftpExtension {
    AbstractMD5Extension(String extensionName) {
        super(extensionName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doMD5Hash(String filename, long startOffset, long length, byte[] quickCheckHash, SftpSubsystem sftp) throws FileNotFoundException, PermissionDeniedException, IOException, SshException, InvalidHandleException {
        AbstractFileSystem fs = sftp.getFileSystem();
        byte[] handle = fs.openFile(filename, new UnsignedInteger32(1L), null);
        try {
            byte[] byArray = this.doMD5Hash(handle, startOffset, length, quickCheckHash, sftp);
            return byArray;
        }
        finally {
            fs.closeFile(handle);
        }
    }

    protected byte[] doMD5Hash(byte[] handle, long startOffset, long length, byte[] quickCheckHash, SftpSubsystem sftp) throws SshException, EOFException, InvalidHandleException, IOException, PermissionDeniedException {
        byte[] tmp = new byte[32768];
        AbstractFileSystem fs = sftp.getFileSystem();
        SftpFileAttributes attrs = fs.getFileAttributes(handle);
        if (length == 0L) {
            length = attrs.getSize().longValue();
        }
        MD5Digest digest = (MD5Digest)JCEComponentManager.getInstance().supportedDigests().getInstance("MD5");
        while (length > 0L) {
            int read = fs.readFile(handle, new UnsignedInteger64(startOffset), tmp, 0, tmp.length);
            if (read <= 0) continue;
            digest.putBytes(tmp, 0, read);
            length -= (long)read;
            startOffset += (long)read;
        }
        return digest.doFinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReply(int requestId, byte[] hashValue, SftpSubsystem sftp) throws IOException {
        try (Packet reply = new Packet();){
            reply.write(201);
            reply.writeInt(requestId);
            reply.writeString("md5-hash");
            reply.writeBinaryString(hashValue);
            sftp.sendMessage(reply);
        }
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
    }
}

