/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.ssh.SshConnection;
import java.net.URI;
import java.net.URISyntaxException;

public class AbstractFileURI {
    public static final String URI_SCHEME = "abfs";
    private String path;
    String connectionUUID;

    private AbstractFileURI(URI uri) {
        AbstractFileURI.validate(uri);
        this.connectionUUID = uri.getAuthority();
        this.path = uri.getPath();
    }

    public static URI create(SshConnection con, String ... paths) {
        try {
            return new URI(URI_SCHEME, con.getUUID(), "/" + String.join((CharSequence)"/", paths), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can not create URI from given input", e);
        }
    }

    static AbstractFileURI parse(URI uri) throws IllegalArgumentException {
        return new AbstractFileURI(uri);
    }

    public String getPath() {
        return this.path;
    }

    public String getConnectionId() {
        return this.connectionUUID;
    }

    private static void validate(URI uri) {
        if (!URI_SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI must have abfs scheme");
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException("URI must have an authority");
        }
        if (uri.getPath() == null || uri.getPath().isEmpty()) {
            throw new IllegalArgumentException("URI must have a path");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("URI must not have a query part");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI must not have a fragment part");
        }
    }
}

