/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.nio.AbstractFileAttributeView;
import com.sshtools.common.files.nio.AbstractFileBasicAttributes;
import com.sshtools.common.files.nio.AbstractFileNIOFileSystem;
import com.sshtools.common.files.nio.AbstractFileURI;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.ssh.SshConnection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AbstractFilePath
implements Path {
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    public static final String SEPARATOR = "/";
    private final AbstractFileNIOFileSystem fileSystem;
    private final List<String> elements;
    private final boolean absolute;
    private final SshConnection con;

    AbstractFilePath(AbstractFileNIOFileSystem fileSystem, List<String> elements, boolean absolute) {
        fileSystem.assertOpen();
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.elements = Collections.unmodifiableList(elements);
        this.absolute = Objects.requireNonNull(absolute);
        this.con = fileSystem.getConnection();
    }

    static AbstractFilePath castAndAssertAbsolute(Path path) {
        AbstractFilePath result = AbstractFilePath.cast(path);
        if (!result.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute but was " + path);
        }
        return result;
    }

    static AbstractFilePath cast(Path path) {
        if (path instanceof AbstractFilePath) {
            AbstractFilePath AbstractFilePath2 = (AbstractFilePath)path;
            AbstractFilePath2.getFileSystem().assertOpen();
            return AbstractFilePath2;
        }
        throw new ProviderMismatchException("Used a path from different provider: " + path);
    }

    @Override
    public AbstractFileNIOFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        this.fileSystem.assertOpen();
        return this.absolute;
    }

    @Override
    public AbstractFilePath getRoot() {
        this.fileSystem.assertOpen();
        return this.absolute ? this.fileSystem.getRootPath() : null;
    }

    @Override
    public AbstractFilePath getFileName() {
        this.fileSystem.assertOpen();
        int elementCount = this.getNameCount();
        if (elementCount == 0) {
            return null;
        }
        return this.getName(elementCount - 1);
    }

    @Override
    public AbstractFilePath getParent() {
        this.fileSystem.assertOpen();
        int elementCount = this.getNameCount();
        if (elementCount > 1) {
            List<String> elems = this.elements.subList(0, elementCount - 1);
            return this.copyWithElements(elems);
        }
        if (elementCount == 1) {
            return this.getRoot();
        }
        return null;
    }

    @Override
    public int getNameCount() {
        this.fileSystem.assertOpen();
        return this.elements.size();
    }

    @Override
    public AbstractFilePath getName(int index) {
        this.fileSystem.assertOpen();
        return this.subpath(index, index + 1);
    }

    @Override
    public AbstractFilePath subpath(int beginIndex, int endIndex) {
        this.fileSystem.assertOpen();
        return new AbstractFilePath(this.fileSystem, this.elements.subList(beginIndex, endIndex), false);
    }

    @Override
    public boolean startsWith(Path path) {
        boolean matchesAbsolute;
        this.fileSystem.assertOpen();
        if (!this.getFileSystem().equals(path.getFileSystem())) {
            return false;
        }
        AbstractFilePath other = AbstractFilePath.cast(path);
        boolean bl = matchesAbsolute = this.isAbsolute() == other.isAbsolute();
        if (matchesAbsolute && other.elements.size() <= this.elements.size()) {
            return this.elements.subList(0, other.elements.size()).equals(other.elements);
        }
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        this.fileSystem.assertOpen();
        return this.startsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path path) {
        this.fileSystem.assertOpen();
        if (!this.getFileSystem().equals(path.getFileSystem())) {
            return false;
        }
        AbstractFilePath other = AbstractFilePath.cast(path);
        if (other.elements.size() <= this.elements.size()) {
            return this.elements.subList(this.elements.size() - other.elements.size(), this.elements.size()).equals(other.elements);
        }
        return false;
    }

    @Override
    public boolean endsWith(String other) {
        this.fileSystem.assertOpen();
        return this.endsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public AbstractFilePath normalize() {
        this.fileSystem.assertOpen();
        LinkedList<String> normalized = new LinkedList<String>();
        for (String elem : this.elements) {
            String lastElem = normalized.peekLast();
            if (elem.isEmpty() || CURRENT_DIR.equals(elem)) continue;
            if (PARENT_DIR.equals(elem) && lastElem != null && !PARENT_DIR.equals(lastElem)) {
                normalized.removeLast();
                continue;
            }
            normalized.add(elem);
        }
        return this.copyWithElements(normalized);
    }

    @Override
    public AbstractFilePath resolve(Path path) {
        this.fileSystem.assertOpen();
        AbstractFilePath other = AbstractFilePath.cast(path);
        if (other.isAbsolute()) {
            return other;
        }
        ArrayList<String> joined = new ArrayList<String>();
        joined.addAll(this.elements);
        joined.addAll(other.elements);
        return this.copyWithElements(joined);
    }

    @Override
    public AbstractFilePath resolve(String other) {
        this.fileSystem.assertOpen();
        return this.resolve(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public AbstractFilePath resolveSibling(Path path) {
        this.fileSystem.assertOpen();
        AbstractFilePath parent = this.getParent();
        AbstractFilePath other = AbstractFilePath.cast(path);
        if (parent == null || other.isAbsolute()) {
            return other;
        }
        return parent.resolve(other);
    }

    @Override
    public AbstractFilePath resolveSibling(String other) {
        this.fileSystem.assertOpen();
        return this.resolveSibling(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public AbstractFilePath relativize(Path path) {
        this.fileSystem.assertOpen();
        AbstractFilePath normalized = this.normalize();
        AbstractFilePath other = AbstractFilePath.cast(path).normalize();
        if (normalized.isAbsolute() == other.isAbsolute()) {
            int commonPrefix = this.countCommonPrefixElements(normalized, other);
            int stepsUp = this.getNameCount() - commonPrefix;
            ArrayList<String> elems = new ArrayList<String>();
            elems.addAll(Collections.nCopies(stepsUp, PARENT_DIR));
            elems.addAll(other.elements.subList(commonPrefix, other.getNameCount()));
            return this.copyWithElementsAndAbsolute(elems, false);
        }
        throw new IllegalArgumentException("Can't relativize an absolute path relative to a relative path.");
    }

    private int countCommonPrefixElements(AbstractFilePath p1, AbstractFilePath p2) {
        int n = Math.min(p1.getNameCount(), p2.getNameCount());
        for (int i = 0; i < n; ++i) {
            if (p1.elements.get(i).equals(p2.elements.get(i))) continue;
            return i;
        }
        return n;
    }

    @Override
    public URI toUri() {
        this.fileSystem.assertOpen();
        return AbstractFileURI.create(this.fileSystem.getConnection(), this.elements.toArray(new String[this.elements.size()]));
    }

    @Override
    public AbstractFilePath toAbsolutePath() {
        this.fileSystem.assertOpen();
        if (this.isAbsolute()) {
            return this;
        }
        return this.copyWithAbsolute(true);
    }

    @Override
    public AbstractFilePath toRealPath(LinkOption ... options) throws IOException {
        this.fileSystem.assertOpen();
        AbstractFilePath normalized = this.normalize().toAbsolutePath();
        if (!Arrays.asList(options).contains(LinkOption.NOFOLLOW_LINKS)) {
            return normalized.resolveAllSymlinksInPath();
        }
        return normalized;
    }

    private AbstractFilePath resolveAllSymlinksInPath() throws IOException {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public File toFile() {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public Iterator<Path> iterator() {
        this.fileSystem.assertOpen();
        return new Iterator<Path>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < AbstractFilePath.this.getNameCount();
            }

            @Override
            public Path next() {
                return AbstractFilePath.this.getName(this.idx++);
            }
        };
    }

    @Override
    public int compareTo(Path path) {
        AbstractFilePath other = (AbstractFilePath)path;
        if (this.isAbsolute() != other.isAbsolute()) {
            return this.isAbsolute() ? -1 : 1;
        }
        for (int i = 0; i < Math.min(this.getNameCount(), other.getNameCount()); ++i) {
            int result = this.elements.get(i).compareTo(other.elements.get(i));
            if (result == 0) continue;
            return result;
        }
        return this.getNameCount() - other.getNameCount();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + this.fileSystem.hashCode();
        hash = 31 * hash + this.elements.hashCode();
        hash = 31 * hash + (this.absolute ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractFilePath) {
            AbstractFilePath other = (AbstractFilePath)obj;
            return this.fileSystem.equals(other.fileSystem) && this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        String prefix = this.absolute ? SEPARATOR : "";
        return prefix + String.join((CharSequence)SEPARATOR, this.elements);
    }

    private AbstractFilePath copyWithElements(List<String> elements) {
        return new AbstractFilePath(this.fileSystem, elements, this.absolute);
    }

    private AbstractFilePath copyWithAbsolute(boolean absolute) {
        return new AbstractFilePath(this.fileSystem, this.elements, absolute);
    }

    private AbstractFilePath copyWithElementsAndAbsolute(List<String> elements, boolean absolute) {
        return new AbstractFilePath(this.fileSystem, elements, absolute);
    }

    public AbstractFile getAbstractFile() throws IOException {
        try {
            return this.con.getContext().getPolicy(FileSystemPolicy.class).getFileFactory().getFileFactory(this.con).getFile(this.toString());
        }
        catch (PermissionDeniedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public AbstractFileBasicAttributes getAttributes() throws IOException {
        return new AbstractFileBasicAttributes(this.getAbstractFile());
    }

    Map<String, Object> readAttributes(String attributes, LinkOption ... options) throws IOException {
        String view = null;
        String attrs = null;
        int colonPos = attributes.indexOf(58);
        if (colonPos == -1) {
            view = "basic";
            attrs = attributes;
        } else {
            view = attributes.substring(0, colonPos++);
            attrs = attributes.substring(colonPos);
        }
        AbstractFileAttributeView zfv = AbstractFileAttributeView.get(this, view);
        if (zfv == null) {
            throw new UnsupportedOperationException("view not supported");
        }
        return zfv.readAttributes(attrs);
    }
}

