/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk.build;

import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class GradleComponentGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleComponentGraphBuilder.class);
    private final String configurationName;

    private Set<String> buildAncestorConfigurations(Configuration configuration) {
        HashSet<String> parentConfigs = new HashSet<String>();
        for (Configuration parent : configuration.getExtendsFrom()) {
            parentConfigs.add(parent.getName());
            parentConfigs.addAll(this.buildAncestorConfigurations(parent));
        }
        return parentConfigs;
    }

    public GradleComponentGraphBuilder(String configurationName) {
        this.configurationName = configurationName;
    }

    public Set<LibraryGraph> generateGraphs(@Nonnull Collection<Project> projects) {
        HashSet<LibraryGraph> graphs = new HashSet<LibraryGraph>();
        for (Project p : projects) {
            try {
                graphs.add(this.buildGraph(p));
            }
            catch (UnknownConfigurationException ex) {
                LOGGER.debug(String.format("No configuration named %s found for %s, skipping", this.configurationName, p.getName()), (Throwable)ex);
            }
        }
        return graphs;
    }

    public Set<LibraryGraph> generateGraphs(@Nonnull Project project) {
        HashSet<LibraryGraph> graphs = new HashSet<LibraryGraph>();
        for (Project p : project.getAllprojects()) {
            try {
                graphs.add(this.buildGraph(p));
            }
            catch (UnknownConfigurationException ex) {
                LOGGER.debug(String.format("No configuration named %s found for %s, skipping", this.configurationName, p.getName()), (Throwable)ex);
            }
        }
        return graphs;
    }

    private LibraryGraph buildGraph(Project project) {
        String buildFileName = project.getBuildFile() != null ? project.getBuildFile().getName() : null;
        LibraryGraph.Builder module = new LibraryGraph.Builder().withCoords(new Coords.Builder().withCoordinateType(CoordinateType.MAVEN).withCoordinate1(project.getGroup().toString()).withCoordinate2(project.getName()).withVersion(project.getVersion().toString()).build()).withModuleName(project.getName()).withFilename(buildFileName);
        Configuration config = project.getConfigurations().getByName(this.configurationName);
        if (config == null) {
            return module.build();
        }
        Set<String> permittedScopes = this.buildAncestorConfigurations(config);
        permittedScopes.add(this.configurationName);
        ResolvedConfiguration resolvedConfig = config.getResolvedConfiguration();
        for (ResolvedDependency d : resolvedConfig.getFirstLevelModuleDependencies()) {
            LibraryGraph libraryGraph = this.buildGraph(d, buildFileName, Collections.unmodifiableCollection(permittedScopes), new HashSet<ResolvedDependency>());
            if (libraryGraph == null) continue;
            module.withDirect(libraryGraph);
        }
        return module.build();
    }

    private LibraryGraph buildGraph(ResolvedDependency d, String buildFileName, Collection<String> permittedScopes, Set<ResolvedDependency> seen) {
        if (seen.contains(d)) {
            return null;
        }
        if (GradleComponentGraphBuilder.hasUnmatchableCoordinate(d)) {
            LOGGER.debug("Coordinate {}:{}:{} cannot be matched and was dropped", new Object[]{d.getModuleGroup(), d.getModuleName(), d.getModuleVersion()});
            return null;
        }
        LibraryGraph.Builder builder = new LibraryGraph.Builder().withCoords(new Coords.Builder().withCoordinateType(CoordinateType.MAVEN).withCoordinates(d.getModuleGroup(), d.getModuleName()).withVersion(d.getModuleVersion()).withScope(this.configurationName).build()).withFilename(buildFileName);
        for (ResolvedDependency dep : d.getChildren()) {
            if (!permittedScopes.contains(dep.getConfiguration()) && !"default".equals(dep.getConfiguration())) continue;
            seen.add(d);
            LibraryGraph libraryGraph = this.buildGraph(dep, buildFileName, permittedScopes, seen);
            if (libraryGraph != null) {
                builder.withDirect(libraryGraph);
            }
            seen.remove(d);
        }
        return builder.build();
    }

    private static boolean hasUnmatchableCoordinate(ResolvedDependency d) {
        return StringUtils.isBlank((CharSequence)d.getModuleGroup()) || StringUtils.isBlank((CharSequence)d.getModuleName()) || StringUtils.isBlank((CharSequence)d.getModuleVersion());
    }
}

