/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.srcclr.sdk.CoordNormalizer;
import com.srcclr.sdk.GoCoordNormalizer;
import com.srcclr.sdk.IdentityNormalizer;
import com.srcclr.sdk.LanguageType;
import com.srcclr.sdk.NugetCoordNormalizer;
import com.srcclr.sdk.PackagistCoordNormalizer;
import com.srcclr.sdk.PythonCoordNormalizer;

public enum CoordinateType {
    MAVEN("Maven", 2, "", IdentityNormalizer.getSingleton(), LanguageType.JAVA),
    GEM("GEM", 1, "ruby", IdentityNormalizer.getSingleton(), LanguageType.RUBY),
    NPM("NPM", 1, "", IdentityNormalizer.getSingleton(), LanguageType.JS),
    BOWER("BOWER", 1, "", IdentityNormalizer.getSingleton(), LanguageType.JS),
    COCOAPODS("COCOAPODS", 1, "", IdentityNormalizer.getSingleton(), LanguageType.OBJECTIVEC),
    PYPI("PYPI", 1, "source", PythonCoordNormalizer.getSingleton(), LanguageType.PYTHON),
    GO("GO", 1, "", GoCoordNormalizer.getSingleton(), LanguageType.GO),
    PACKAGIST("PACKAGIST", 1, "", PackagistCoordNormalizer.getSingleton(), LanguageType.PHP),
    SO("SO", 1, "", IdentityNormalizer.getSingleton(), LanguageType.CPP),
    NUGET("NUGET", 1, "", NugetCoordNormalizer.getSingleton(), LanguageType.CSHARP);

    private final String name;
    private final int coordinateCount;
    private final String defaultPlatformName;
    private CoordNormalizer normalizer;
    private final LanguageType primaryLanguage;

    private CoordinateType(String name, int coordinateCount, String defaultPlatformName, CoordNormalizer normalizer, LanguageType primaryLanguage) {
        this.name = name;
        this.coordinateCount = coordinateCount;
        this.defaultPlatformName = defaultPlatformName;
        this.normalizer = normalizer;
        this.primaryLanguage = primaryLanguage;
    }

    public int getCoordinateCount() {
        return this.coordinateCount;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultPlatformName() {
        return this.defaultPlatformName;
    }

    public LanguageType getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    public CoordNormalizer getNormalizer() {
        return this.normalizer;
    }

    @JsonCreator
    public static CoordinateType toCoordType(String strVal) {
        if (strVal == null) {
            return null;
        }
        String upperVal = strVal.toUpperCase();
        return CoordinateType.valueOf(upperVal);
    }
}

