/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.lexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.jcodings.Encoding;
import org.jruby.util.ByteList;
import org.jrubyparser.lexer.LexerSource;

public class ByteListLexerSource
extends LexerSource {
    private ByteList completeSource;
    private int offset = 0;

    public ByteListLexerSource(String sourceName, int line, ByteList in) {
        super(sourceName, line);
        this.completeSource = in;
    }

    public static ByteListLexerSource getLexerSource(String sourceName, int line, Reader reader) throws IOException {
        ByteList byteList = new ByteList(80);
        BufferedReader bufferedReader = new BufferedReader(reader);
        String s = bufferedReader.readLine();
        if (s == null) {
            return new ByteListLexerSource(sourceName, line, new ByteList(0));
        }
        while (true) {
            byteList.append(s.getBytes());
            s = bufferedReader.readLine();
            if (s == null) break;
            byteList.append("\n".getBytes());
        }
        return new ByteListLexerSource(sourceName, line, byteList);
    }

    @Override
    public Encoding getEncoding() {
        return this.completeSource.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding) {
        this.completeSource.setEncoding(encoding);
    }

    @Override
    public ByteList gets() {
        int length = this.completeSource.length();
        if (this.offset >= length) {
            return null;
        }
        int end = this.completeSource.indexOf(10, this.offset) + 1;
        if (end == 0) {
            end = length;
        }
        ByteList line = this.completeSource.makeShared(this.offset, end - this.offset);
        this.offset = end;
        return line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }
}

