/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.parser.StaticScope;

public class ForNode
extends IterNode {
    private Node iterNode;

    public ForNode(ISourcePosition position, Node varNode, Node bodyNode, Node iterNode, StaticScope scope) {
        super(position, varNode, scope, bodyNode);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = iterNode;
    }

    @Override
    public ArgsNode getArgsNode() {
        throw new IllegalArgumentException("For nodes are not technically def nodes so they do not have args");
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FORNODE;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitForNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }
}

