/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class ArgumentNode
extends Node
implements INameNode {
    private String identifier;
    private int location;

    public ArgumentNode(ISourcePosition position, String identifier) {
        super(position, false);
        this.identifier = identifier;
    }

    public ArgumentNode(ISourcePosition position, String identifier, int location) {
        this(position, identifier);
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGUMENTNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArgumentNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    public void setName(String name) {
        this.identifier = name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

