/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.KeywordRestArgNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.RequiredKeywordArgumentValueNode;
import org.jrubyparser.ast.RestArgNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class ArgsNode
extends Node {
    private Node[] args;
    private short optIndex;
    private short postIndex;
    private short keywordsIndex;
    protected final ArgumentNode restArgNode;
    private final KeywordRestArgNode keyRest;
    private final BlockArgNode blockArgNode;
    private ListNode blockLocalVariables = null;
    private static final Node[] NO_ARGS = new Node[0];

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest, ListNode post, BlockArgNode blockArgNode) {
        this(position, pre, optionalArguments, rest, post, null, null, blockArgNode);
    }

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest, ListNode post, ListNode keywords, KeywordRestArgNode keyRest, BlockArgNode blockArgNode) {
        super(position, pre != null && pre.containsVariableAssignment() || optionalArguments != null && optionalArguments.containsVariableAssignment() || rest != null && rest.containsVariableAssignment() || post != null && post.containsVariableAssignment() || keywords != null && keywords.containsVariableAssignment() || keyRest != null && keyRest.containsVariableAssignment() || blockArgNode != null && blockArgNode.containsVariableAssignment());
        int preSize = pre != null ? pre.size() : 0;
        int optSize = optionalArguments != null ? optionalArguments.size() : 0;
        int postSize = post != null ? post.size() : 0;
        int keywordsSize = keywords != null ? keywords.size() : 0;
        int size = preSize + optSize + postSize + keywordsSize;
        this.args = size > 0 ? new Node[size] : NO_ARGS;
        this.optIndex = (short)(preSize != 0 ? preSize : 0);
        this.postIndex = (short)(optSize != 0 ? this.optIndex + optSize : this.optIndex);
        this.keywordsIndex = (short)(postSize != 0 ? this.postIndex + postSize : this.postIndex);
        if (preSize > 0) {
            System.arraycopy(pre.children(), 0, this.args, 0, preSize);
        }
        if (optSize > 0) {
            System.arraycopy(optionalArguments.children(), 0, this.args, this.optIndex, optSize);
        }
        if (postSize > 0) {
            System.arraycopy(post.children(), 0, this.args, this.postIndex, postSize);
        }
        if (keywordsSize > 0) {
            System.arraycopy(keywords.children(), 0, this.args, this.keywordsIndex, keywordsSize);
        }
        this.restArgNode = rest;
        this.blockArgNode = blockArgNode;
        this.keyRest = keyRest;
    }

    public Node[] getArgs() {
        return this.args;
    }

    public int getOptArgIndex() {
        return this.optIndex;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public int getKeywordsIndex() {
        return this.keywordsIndex;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    public boolean hasKwargs() {
        boolean keywords = this.getKeywordCount() > 0;
        return keywords || this.keyRest != null;
    }

    public int countKeywords() {
        if (this.hasKwargs()) {
            boolean keywords;
            boolean bl = keywords = this.args.length - this.keywordsIndex > 0;
            if (keywords) {
                return 0;
            }
            return this.args.length - this.keywordsIndex;
        }
        return 0;
    }

    public boolean hasRestArg() {
        return this.restArgNode != null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getPre() {
        return new ListNode(this.getPosition()).addAll(this.args, 0, this.getPreCount());
    }

    public int getRequiredArgsCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public int getOptionalArgsCount() {
        return this.postIndex - this.optIndex;
    }

    public ListNode getPost() {
        return new ListNode(this.getPosition()).addAll(this.args, this.postIndex, this.getPostCount());
    }

    public int getMaxArgumentsCount() {
        return this.hasRestArg() ? -1 : this.getRequiredArgsCount() + this.getOptionalArgsCount();
    }

    public ListNode getOptArgs() {
        return new ListNode(this.getPosition()).addAll(this.args, this.optIndex, this.getOptionalArgsCount());
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    public BlockArgNode getBlock() {
        return this.blockArgNode;
    }

    public int getPostCount() {
        return this.keywordsIndex - this.postIndex;
    }

    public int getPreCount() {
        return this.optIndex;
    }

    public ListNode getKeywords() {
        return new ListNode(this.getPosition()).addAll(this.args, this.keywordsIndex, this.getKeywordCount());
    }

    public KeywordRestArgNode getKeyRest() {
        return this.keyRest;
    }

    public boolean hasKeyRest() {
        return this.keyRest != null;
    }

    @Override
    public List<Node> childNodes() {
        ListNode post = this.getPost();
        ListNode keywords = this.getKeywords();
        ListNode pre = this.getPre();
        ListNode optArgs = this.getOptArgs();
        if (post != null) {
            if (keywords != null) {
                if (this.keyRest != null) {
                    return Node.createList(pre, optArgs, this.restArgNode, post, keywords, this.keyRest, this.blockArgNode);
                }
                return Node.createList(pre, optArgs, this.restArgNode, post, keywords, this.blockArgNode);
            }
            return Node.createList(pre, optArgs, this.restArgNode, post, this.blockArgNode);
        }
        if (keywords != null) {
            if (this.keyRest != null) {
                return Node.createList(pre, optArgs, this.restArgNode, keywords, this.keyRest, this.blockArgNode);
            }
            return Node.createList(pre, optArgs, this.restArgNode, keywords, this.blockArgNode);
        }
        return Node.createList(pre, optArgs, this.restArgNode, this.blockArgNode);
    }

    public int getKeywordCount() {
        return this.args.length - this.keywordsIndex;
    }

    public int getRequiredKeywordCount() {
        if (this.getKeywordCount() < 1) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.getKeywordCount(); ++i) {
            for (Node asgnNode : this.args[this.keywordsIndex + i].childNodes()) {
                if (!ArgsNode.isRequiredKeywordArgumentValueNode(asgnNode)) continue;
                ++count;
            }
        }
        return count;
    }

    private static boolean isRequiredKeywordArgumentValueNode(Node asgnNode) {
        return asgnNode.childNodes().get(0) instanceof RequiredKeywordArgumentValueNode;
    }

    public ListNode getBlockLocalVariables() {
        return this.blockLocalVariables;
    }

    public void setBlockLocalVariables(ListNode blockLocalVariables) {
        this.blockLocalVariables = blockLocalVariables;
    }
}

