/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class RubyEncoding {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final ThreadLocal<SoftReference<UTF8Coder>> UTF8_CODER = new ThreadLocal();

    public static String decodeUTF8(byte[] bytes, int start, int length) {
        return RubyEncoding.getUTF8Coder().decode(bytes, start, length);
    }

    private static UTF8Coder getUTF8Coder() {
        UTF8Coder coder;
        SoftReference<UTF8Coder> ref = UTF8_CODER.get();
        if (ref == null || (coder = ref.get()) == null) {
            coder = new UTF8Coder();
            ref = new SoftReference<UTF8Coder>(coder);
            UTF8_CODER.set(ref);
        }
        return coder;
    }

    private static class UTF8Coder {
        private final CharsetEncoder encoder = UTF8.newEncoder();
        private final CharsetDecoder decoder = UTF8.newDecoder();
        private static final int CHAR_THRESHOLD = 1024;
        private static final int BUF_SIZE = 4096;
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        private final CharBuffer charBuffer = CharBuffer.allocate(4096);

        UTF8Coder() {
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        public final byte[] encode(CharSequence cs) {
            ByteBuffer buffer;
            if (cs.length() > 1024) {
                buffer = UTF8.encode(CharBuffer.wrap(cs));
            } else {
                buffer = this.byteBuffer;
                CharBuffer cbuffer = this.charBuffer;
                buffer.clear();
                cbuffer.clear();
                cbuffer.put(cs.toString());
                cbuffer.flip();
                this.encoder.encode(cbuffer, buffer, true);
                buffer.flip();
            }
            byte[] bytes = new byte[buffer.limit()];
            buffer.get(bytes);
            return bytes;
        }

        public final String decode(byte[] bytes, int start, int length) {
            CharBuffer cbuffer;
            if (length > 1024) {
                cbuffer = UTF8.decode(ByteBuffer.wrap(bytes, start, length));
            } else {
                cbuffer = this.charBuffer;
                ByteBuffer buffer = this.byteBuffer;
                cbuffer.clear();
                buffer.clear();
                buffer.put(bytes, start, length);
                buffer.flip();
                this.decoder.decode(buffer, cbuffer, true);
                cbuffer.flip();
            }
            return cbuffer.toString();
        }

        public final String decode(byte[] bytes) {
            return this.decode(bytes, 0, bytes.length);
        }
    }
}

