/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.sourceclear.util.system.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IO {
    private static final Logger LOGGER = LoggerFactory.getLogger(IO.class);

    public static File downloadFileIntoDir(URL url, String filename, File directory, EnumSet<PosixFilePermission> filePermissions, boolean overwriteExisting) throws IOException {
        return IO.downloadFileIntoDir(url, filename, directory, filePermissions, overwriteExisting, 3);
    }

    public static File downloadFileIntoDir(URL url, String filename, File directory, EnumSet<PosixFilePermission> filePermissions, boolean overwriteExisting, int retries) throws IOException {
        File fileToDownload = new File(directory, filename);
        if (directory.exists()) {
            if (fileToDownload.exists() && !overwriteExisting) {
                LOGGER.debug("Returning existing {}. File size: {}.", (Object)fileToDownload, (Object)fileToDownload.length());
                return fileToDownload;
            }
            FileUtils.deleteDirectory((File)directory);
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create directory: '" + directory.getAbsolutePath() + "'!");
        }
        for (int i = 0; i < retries; ++i) {
            block41: {
                if (i > 0) {
                    int wait = (int)Math.pow(3.0, i);
                    LOGGER.debug("Waiting for {} seconds before attempting downloading again.", (Object)wait);
                    try {
                        TimeUnit.SECONDS.sleep(wait);
                    }
                    catch (InterruptedException ex) {
                        throw new IOException(String.format("Unable to download file from %s.", url), ex);
                    }
                }
                LOGGER.debug("Attempt downloading from {} {} out of {} times.", new Object[]{url, i + 1, retries});
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(5000);
                long contentLength = connection.getContentLengthLong();
                try (InputStream fileIn = url.openStream();){
                    Files.copy(fileIn, fileToDownload.toPath(), new CopyOption[0]);
                }
                catch (IOException ex) {
                    if (i == retries - 1) {
                        throw ex;
                    }
                    LOGGER.debug("Exception occurred. Retrying: ", (Throwable)ex);
                    continue;
                }
                long fileLength = fileToDownload.length();
                if (fileLength != contentLength) {
                    String wrongLengthMsg = String.format("Received %d bytes while getting the file, but expected %d bytes.%nThe connection was probably interrupted.", fileLength, contentLength);
                    LOGGER.debug(wrongLengthMsg);
                    try {
                        Files.delete(fileToDownload.toPath());
                    }
                    catch (IOException ex) {
                        throw new IOException(String.format("%s Unable to delete '%s' for retry.", wrongLengthMsg, fileToDownload), ex);
                    }
                    if (i != retries - 1) continue;
                    throw new IOException(wrongLengthMsg + String.format(" Number of attempts to download file: %s.", retries));
                }
                String md5 = connection.getHeaderField("ETag");
                if (md5 == null) {
                    LOGGER.debug("no md5 value in header. skipping this check.");
                } else {
                    try (InputStream inputStream = Files.newInputStream(fileToDownload.toPath(), new OpenOption[0]);){
                        String downloadedMD5 = DigestUtils.md5Hex((InputStream)inputStream);
                        if (md5.replace("\"", "").equalsIgnoreCase(downloadedMD5)) {
                            LOGGER.debug("md5 check passed.");
                            break block41;
                        }
                        throw new IOException(String.format("MD5 of downloaded file does not match etag value. %s != %s.", downloadedMD5, md5));
                    }
                }
            }
            LOGGER.debug("{} downloaded.", (Object)fileToDownload);
            OS.setPosixFilePermissions(fileToDownload.toPath(), filePermissions);
            break;
        }
        return fileToDownload;
    }
}

