/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidencePath;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvidenceUtils.class);

    @Nonnull
    public static Collection<Evidence> evidenceFromLibraryGraphs(@Nonnull Collection<LibraryGraph> libraryGraphs) {
        HashMap<CustomCoord, Evidence.Builder> evidenceMap = new HashMap<CustomCoord, Evidence.Builder>();
        LinkedHashSet<Evidence> jarEvidence = new LinkedHashSet<Evidence>();
        HashSet<Evidence> dllEvidences = new HashSet<Evidence>();
        for (LibraryGraph graph : libraryGraphs) {
            for (LibraryGraph direct : graph.getDirects()) {
                EvidenceUtils.buildEvidence(evidenceMap, direct, Collections.emptyList());
            }
            String graphFilename = graph.getFilename();
            if (graph.getCoords() != null || graphFilename == null) continue;
            Evidence.Builder evidenceBuilder = new Evidence.Builder().withEvidencePath(new EvidencePath(graphFilename, null)).withByteCodeHash(graph.getBytecodeHash()).withSha1(graph.getSha1()).withSha2(graph.getSha2());
            if (graphFilename.endsWith(".jar")) {
                jarEvidence.add(evidenceBuilder.withEvidenceType(EvidenceType.JAR).build());
                continue;
            }
            if (!graphFilename.endsWith(".dll")) continue;
            dllEvidences.add(evidenceBuilder.withEvidenceType(EvidenceType.DLL).build());
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Evidence.Builder eb : evidenceMap.values()) {
            builder.add((Object)eb.build());
        }
        builder.addAll(jarEvidence);
        builder.addAll(dllEvidences);
        return builder.build();
    }

    private static void buildEvidence(Map<CustomCoord, Evidence.Builder> map, LibraryGraph graph, List<Coordinates> coordPath) {
        Coords coords = graph.getCoords();
        if (coords == null) {
            LOGGER.warn("Found null coordinates for a LibraryGraph!");
            return;
        }
        CustomCoord customCoord = new CustomCoord(coords);
        Evidence.Builder builder = map.get(customCoord);
        if (builder == null) {
            builder = new Evidence.Builder().withCoordinates(EvidenceUtils.apiCoordinatesFromSDKCoords(graph.getCoords()));
            if (coords.getCoordinateType() == com.srcclr.sdk.CoordinateType.SO) {
                builder.withEvidenceType(EvidenceType.SO);
                builder.withSha2(graph.getSha2());
            } else if (graph.getCoords().getCommitHash() != null) {
                builder.withCommitHash(graph.getCoords().getCommitHash());
                builder.withEvidenceType(EvidenceType.COMMIT);
            } else {
                builder.withEvidenceType(EvidenceType.COORDINATES);
            }
            map.put(customCoord, builder);
        }
        EvidencePath evidencePath = new EvidencePath(graph.getFilename(), graph.getLineNumber(), coordPath);
        builder.withEvidencePath(evidencePath);
        for (LibraryGraph direct : graph.getDirects()) {
            ArrayList<Coordinates> path = new ArrayList<Coordinates>(coordPath);
            path.add(EvidenceUtils.apiCoordinatesFromSDKCoords(graph.getCoords()));
            EvidenceUtils.buildEvidence(map, direct, path);
        }
    }

    private static Coordinates apiCoordinatesFromSDKCoords(Coords coords) {
        return new Coordinates.Builder().withCoordinateType(CoordinateType.valueOf(coords.getCoordinateType().name())).withCoordinates(coords.getCoordinate1(), coords.getCoordinate2()).withScope(coords.getScope()).withVersion(coords.getVersion()).build();
    }

    private EvidenceUtils() {
    }

    private static class CustomCoord {
        private final Coords coords;

        CustomCoord(Coords coords) {
            this.coords = coords;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomCoord)) {
                return false;
            }
            CustomCoord that = (CustomCoord)o;
            return Objects.equals(this.coords.getCoordinateType(), that.coords.getCoordinateType()) && Objects.equals(this.coords.getCoordinate1(), that.coords.getCoordinate1()) && Objects.equals(this.coords.getCoordinate2(), that.coords.getCoordinate2()) && Objects.equals(this.coords.getVersion(), that.coords.getVersion()) && Objects.equals(this.coords.getPlatform(), that.coords.getPlatform()) && Objects.equals(this.coords.getCommitHash(), that.coords.getCommitHash());
        }

        public int hashCode() {
            return Objects.hash(this.coords.getCoordinateType(), this.coords.getCoordinate1(), this.coords.getCoordinate2(), this.coords.getVersion(), this.coords.getPlatform(), this.coords.getCommitHash());
        }

        public String toString() {
            return "CustomCoord{coords=" + this.coords + '}';
        }
    }
}

