/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FilenameSplitter {
    private static final Pattern SEPARATOR = Pattern.compile("(.+?)(?:[\\.\\-_](\\d.*))??\\.(\\w+)");

    public static LibData split(String filename) {
        Matcher m = SEPARATOR.matcher(filename);
        if (!m.matches()) {
            return null;
        }
        return new LibData(m.group(1), m.group(2), m.group(3));
    }

    private FilenameSplitter() {
    }

    @Immutable
    public static final class LibData {
        private final String libraryName;
        private final String libraryVersion;
        private final String extension;

        public LibData(String libraryName, String libraryVersion, String extension) {
            this.libraryName = libraryName;
            this.libraryVersion = libraryVersion;
            this.extension = extension;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getLibraryVersion() {
            return this.libraryVersion;
        }

        public String getExtension() {
            return this.extension;
        }

        public String toString() {
            return this.libraryName + ":" + this.extension + ":" + this.libraryVersion;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LibData)) {
                return false;
            }
            LibData other = (LibData)LibData.class.cast(obj);
            return Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.extension, other.extension);
        }

        public int hashCode() {
            return Objects.hash(this.libraryName, this.libraryVersion, this.extension);
        }
    }
}

