/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

public class CpeSplitter {
    private static final Pattern SEPARATOR = Pattern.compile("(?:cpe:/)?+(?:(.+?)??(?::(.+?)??(?::(.+?)??(?::(.+?)??)??)??)??)??", 2);

    public static CpeData split(String cpeString) {
        Matcher m = SEPARATOR.matcher(cpeString);
        if (!m.matches()) {
            return null;
        }
        return new CpeData(m.group(1), m.group(2), m.group(3), m.group(4));
    }

    @Immutable
    public static final class CpeData {
        private final String part;
        private final String vendor;
        private final String product;
        private final String version;

        public CpeData(String part, String vendor, String product, String version) {
            this.part = part;
            this.vendor = vendor;
            this.product = product;
            this.version = version;
        }

        public String getPart() {
            return this.part;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getProduct() {
            return this.product;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "cpe [part=" + this.part + ", vendor=" + this.vendor + ", product=" + this.product + ", version=" + this.version + "]";
        }

        public int hashCode() {
            return Objects.hash(this.part, this.vendor, this.product, this.version);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CpeData other = (CpeData)obj;
            return Objects.equals(this.part, other.part) && Objects.equals(this.vendor, other.vendor) && Objects.equals(this.product, other.product) && Objects.equals(this.version, other.version);
        }
    }
}

