/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.printer;

import com.sourceclear.sgl.StepsToPatterns;
import com.sourceclear.sgl.Utility;
import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.PredicateVisitor;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.PredicateArgument;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.SGLDate;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.expr.Step;
import com.sourceclear.sgl.lang.expr.Traversal;
import com.sourceclear.sgl.lang.expr.TraversalArgument;
import com.sourceclear.sgl.lang.expr.Value;
import com.sourceclear.sgl.lang.expr.WildcardArgument;
import com.sourceclear.sgl.lang.predicate.And;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Neg;
import com.sourceclear.sgl.lang.predicate.Or;
import com.sourceclear.sgl.lang.predicate.Regex;
import com.sourceclear.sgl.lang.predicate.Relational;
import com.sourceclear.sgl.lang.predicate.Within;
import java.util.List;
import java.util.stream.Collectors;

public class ASTPrinter
extends ASTVisitor<String, String, String>
implements PredicateVisitor<String> {
    public static String print(Expr expr) {
        return expr.accept(new ASTPrinter());
    }

    @Override
    public String visit(Expr expr) {
        return expr.accept(this);
    }

    @Override
    public String visit(Traversal traversal) {
        return traversal.accept(this);
    }

    @Override
    public String visitBindingSequence(BindingSequence bindingSequence) {
        StringBuilder query = new StringBuilder();
        for (Binding binding : bindingSequence.getBindings()) {
            String lhs = binding.getVariable();
            String rhs = this.visit(binding.getExpr());
            query.append(String.format("let %s = %s in ", lhs, rhs));
        }
        String rest = this.visit(bindingSequence.getBody());
        query.append(rest);
        return query.toString();
    }

    @Override
    public String visitSequence(Sequence sequence) {
        return String.join((CharSequence)";", sequence.getActions().stream().map(this::visit).collect(Collectors.toList()));
    }

    @Override
    public String visitAddAction(AddAction action) {
        return String.format("add %s", this.visit(action.getTraversal()));
    }

    @Override
    public String visitRemoveAction(RemoveAction action) {
        return String.format("remove %s", this.visit(action.getTraversal()));
    }

    @Override
    public String visitStep(Step step) {
        String name = step.getName();
        String args = this.visitArguments(step.getArguments());
        StringBuilder sb = new StringBuilder(String.format("%s%s", name, args));
        step.getNext().ifPresent(next -> {
            sb.append(" ");
            sb.append(this.visit((Traversal)next));
        });
        return sb.toString();
    }

    private String visitArguments(List<Argument> arguments) {
        if (arguments.isEmpty()) {
            return "";
        }
        return String.format("(%s)", String.join((CharSequence)", ", arguments.stream().map(this::visit).collect(Collectors.toList())));
    }

    @Override
    public String visitPredicateArgument(PredicateArgument predicateArgument) {
        StringBuilder sb = new StringBuilder();
        predicateArgument.getKeyword().ifPresent(kw -> {
            sb.append((String)kw);
            sb.append(": ");
        });
        sb.append((String)this.visit(predicateArgument.getPredicate()));
        return sb.toString();
    }

    @Override
    public String visitTraversalArgument(TraversalArgument traversalArgument) {
        StringBuilder sb = new StringBuilder();
        traversalArgument.getKeyword().ifPresent(kw -> {
            sb.append((String)kw);
            sb.append(": ");
        });
        sb.append(this.visit(traversalArgument.getTraversal()));
        return sb.toString();
    }

    @Override
    public String visitWildcardArgument(WildcardArgument wildcardArgument) {
        StringBuilder sb = new StringBuilder();
        wildcardArgument.getKeyword().ifPresent(kw -> {
            sb.append((String)kw);
            sb.append(": ");
        });
        sb.append("_");
        return sb.toString();
    }

    @Override
    public String visitPatterns(Patterns patterns) {
        return patterns.getNamed().stream().map(s -> String.format("%s%s%s", StepsToPatterns.isGenerated(s.start()) ? "" : "?" + s.start() + " ", s.step().accept(this), s.end().filter(x -> !StepsToPatterns.isGenerated(x)).map(x -> " ?" + x).orElse(""))).collect(Collectors.joining(", "));
    }

    @Override
    public String visitQuery(Query query) {
        return this.visit(query.getStep());
    }

    @Override
    public String visitAnd(And and) {
        return String.format("(%s and %s)", this.visit(and.getLeft()), this.visit(and.getRight()));
    }

    @Override
    public String visitOr(Or or) {
        return String.format("(%s and %s)", this.visit(or.getLeft()), this.visit(or.getRight()));
    }

    @Override
    public String visitNot(Neg neg) {
        return String.format("(neg %s)", this.visit(neg.getPred()));
    }

    @Override
    public String visitRelational(Relational relational) {
        return String.format("(%s %s)", relational.getOp().toString(), this.visitValue(relational.getValue()));
    }

    @Override
    public String visitWithin(Within within) {
        Iterable values = within.getValues().stream().map(this::visitValue).collect(Collectors.toList());
        return String.format("(within %s)", String.join((CharSequence)", ", values));
    }

    @Override
    public String visitEq(Eq eq) {
        return this.visitValue(eq.getValue());
    }

    @Override
    public String visitRegex(Regex regex) {
        return String.format("(regex %s)", Utility.quoteString(regex.getRegex()));
    }

    private String visitValue(Value value) {
        if (value.isString()) {
            String s = value.getValue().toString();
            return Utility.quoteString(s);
        }
        if (value.isDate()) {
            return ((SGLDate)value).printDate();
        }
        return value.getValue().toString();
    }
}

