/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.expr;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Traversal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class Step
implements Traversal {
    private final String name;
    private final List<Argument> arguments;
    @Nullable
    private final Step next;

    public Step(String name, List<Argument> arguments, Step next) {
        this.name = name;
        this.arguments = arguments;
        this.next = next;
    }

    public Step(String name, Step next) {
        this(name, new ArrayList<Argument>(), next);
    }

    public Step(String name, List<Argument> arguments) {
        this(name, arguments, null);
    }

    public Step(String name) {
        this(name, new ArrayList<Argument>(), null);
    }

    @Override
    public <E, T, A> T accept(ASTVisitor<E, T, A> visitor) {
        return visitor.visitStep(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step step = (Step)o;
        return Objects.equals(this.name, step.name) && Objects.equals(this.arguments, step.arguments) && Objects.equals(this.next, step.next);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.next);
    }

    public String toString() {
        return "Step{name='" + this.name + '\'' + ", arguments=" + this.arguments + ", next=" + this.next + '}';
    }

    public String getName() {
        return this.name;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public Optional<Step> getNext() {
        return Optional.ofNullable(this.next);
    }

    public Step concat(Step with) {
        if (this.next == null) {
            return new Step(this.name, this.arguments, with);
        }
        return new Step(this.name, this.arguments, this.next.concat(with));
    }

    public Step withNext(Step with) {
        return new Step(this.name, this.arguments, with);
    }

    public Step only() {
        return new Step(this.name, this.arguments);
    }
}

