/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.expr;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Value;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Predicate;
import java.util.Objects;

public class PredicateArgument
extends Argument {
    private final Predicate predicate;

    public PredicateArgument(String keyword, Predicate predicate) {
        super(keyword);
        this.predicate = predicate;
    }

    public PredicateArgument(Predicate predicate) {
        this(null, predicate);
    }

    @Override
    public <E, T, A> A accept(ASTVisitor<E, T, A> visitor) {
        return visitor.visitPredicateArgument(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateArgument that = (PredicateArgument)o;
        return Objects.equals(this.predicate, that.predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.predicate);
    }

    public String toString() {
        return this.getKeyword().map(k -> String.format("%s: %s", k, this.predicate.toString())).orElseGet(this.predicate::toString);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Value getValueUnsafe() {
        if (this.predicate instanceof Eq) {
            return ((Eq)this.predicate).getValue();
        }
        throw new RuntimeException("predicate " + this + " has no concrete value");
    }
}

