/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.expr;

import com.sourceclear.sgl.Utility;
import com.sourceclear.sgl.lang.expr.EvaluatedArgument;
import com.sourceclear.sgl.lang.printer.QueryNormalizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;

public class EvaluatedArguments {
    private final Map<String, Object> args;
    private final List<String> argNames;
    private final int arity;
    private final boolean scan;

    public EvaluatedArguments(List<EvaluatedArgument<Object>> args, List<String> argNames) {
        this.arity = argNames.size();
        this.argNames = argNames;
        boolean isScan = args.stream().allMatch(EvaluatedArgument::isWildcard);
        if (isScan) {
            this.scan = true;
            this.args = Collections.emptyMap();
        } else {
            this.scan = false;
            this.args = this.wrangleArguments(args);
        }
    }

    private Map<String, Object> wrangleArguments(List<EvaluatedArgument<Object>> givenArgs) {
        boolean allNotNamed;
        boolean allNamedXorNot;
        boolean allNamed = givenArgs.stream().allMatch(a -> a.getKeyword().isPresent());
        boolean bl = allNamedXorNot = allNamed != (allNotNamed = givenArgs.stream().noneMatch(a -> a.getKeyword().isPresent()));
        if (!allNamedXorNot) {
            throw new RuntimeException("all arguments should be named, or none should be");
        }
        if (givenArgs.isEmpty()) {
            throw new RuntimeException("too few arguments given, expected " + this.arity);
        }
        if (allNotNamed && givenArgs.size() < this.arity) {
            throw new RuntimeException(String.format("too few positional arguments given, expected %s; either use keyword arguments or use wildcards as placeholders", this.argNames));
        }
        if (givenArgs.size() > this.arity) {
            throw new RuntimeException("too many arguments given, expected a maximum of " + this.argNames.size());
        }
        if (allNamed && givenArgs.stream().flatMap(a -> Stream.of(a.getKeyword())).distinct().count() < (long)givenArgs.size()) {
            throw new RuntimeException("duplicate keyword arguments are not allowed");
        }
        assert (givenArgs.size() <= this.arity);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < givenArgs.size(); ++i) {
            assert (this.argNames.size() - 1 >= i);
            String name = givenArgs.get(i).getKeyword().map(n -> {
                if (!this.argNames.contains(n)) {
                    throw new RuntimeException("unknown keyword argument name " + n);
                }
                return n;
            }).orElse(this.argNames.get(i));
            if (givenArgs.get(i).isWildcard()) continue;
            result.put(name, givenArgs.get(i).getValue());
        }
        return result;
    }

    public QueryType decideQueryType(Set<String> indexed, Set<String> inPK) {
        boolean nonIndexedPresent;
        HashSet<String> all = new HashSet<String>(this.argNames);
        Set<String> given = this.args.keySet();
        assert (Utility.isSubsetOf(given, all)) : "given arguments should be a subset of all arguments";
        assert (Utility.isSubsetOf(inPK, all)) : "arguments in PK should be a subset of all arguments";
        assert (Utility.isSubsetOf(indexed, all)) : "indexed arguments should be a subset of all arguments";
        Set<String> cannotBeQueriedBy = Utility.diff(Utility.diff(given, indexed), inPK);
        boolean hasUnqueryableBy = cannotBeQueriedBy.stream().anyMatch(given::contains);
        if (hasUnqueryableBy) {
            throw new RuntimeException(String.format("cannot query by any of %s as they are not indexed and not part of the primary key", cannotBeQueriedBy));
        }
        assert (Utility.isSubsetOf(given, Utility.union(indexed, inPK))) : "any given property must be indexed or in the PK";
        assert (Utility.isSubsetOf(Utility.diff(given, indexed), inPK)) : "a non-indexed property must be in the PK";
        boolean allLiterals = this.isAllLiterals() || this.isAllPredicateLiterals();
        boolean bl = nonIndexedPresent = !Utility.diff(given, indexed).isEmpty();
        if (given.equals(inPK) && allLiterals) {
            return QueryType.HAS_ID;
        }
        assert (Utility.isSubsetOf(Utility.diff(given, inPK), indexed)) : "given properties must be indexed";
        return QueryType.HAS;
    }

    public void applySchemaDependentTransformations(QueryType queryType) {
        String MODULE_NAME = "module_name";
        String COORD2 = "coord2";
        String LANGUAGE = "language";
        String QUERY = "query";
        if (queryType == QueryType.HAS) {
            if (this.args.containsKey(MODULE_NAME) && this.getValue(this.args.get(MODULE_NAME)).filter(e -> e.equals("null")).isPresent()) {
                if (this.args.size() == 1) {
                    throw new RuntimeException("cannot query by null module name");
                }
                this.args.remove(MODULE_NAME);
            } else if (this.args.containsKey(LANGUAGE) && this.getValue(this.args.get(LANGUAGE)).filter(e -> !e.equals("java")).isPresent() && this.args.containsKey(COORD2) && this.getValue(this.args.get(COORD2)).filter(e -> e.equals("null")).isPresent()) {
                this.args.remove(COORD2);
            }
        } else if (this.args.containsKey(QUERY)) {
            Object query = this.args.get(QUERY);
            if (query instanceof String) {
                this.args.put(QUERY, QueryNormalizer.normalizeAndPrint((String)query));
            } else if (query instanceof P && ((P)query).getBiPredicate().toString().equals("eq")) {
                String normalized = QueryNormalizer.normalizeAndPrint((String)((P)query).getValue());
                ((P)query).setValue((Object)normalized);
            } else {
                throw new RuntimeException("invalid type for query: " + query.getClass().getSimpleName());
            }
        }
    }

    public Object get(String name) {
        return this.args.get(name);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.args.entrySet();
    }

    private Optional<String> getValue(Object o) {
        if (o instanceof String) {
            return Optional.of((String)o);
        }
        if (o instanceof P && ((P)o).getBiPredicate().toString().equals("eq")) {
            return Optional.of((String)((P)o).getValue());
        }
        return Optional.empty();
    }

    public void stripPredicates() {
        if (!this.isAllLiterals()) {
            this.args.keySet().forEach(k -> this.args.put((String)k, ((P)this.args.get(k)).getValue()));
        }
    }

    private boolean isAllPredicateLiterals() {
        return this.args.values().stream().allMatch(a -> a instanceof P && ((P)a).getBiPredicate() == Compare.eq);
    }

    private boolean isAllLiterals() {
        return this.args.values().stream().allMatch(a -> a instanceof String || a instanceof Integer);
    }

    public boolean isScan() {
        return this.scan;
    }

    public static enum QueryType {
        HAS_ID,
        HAS;

    }
}

