/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.Schema;
import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.Action;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.PredicateArgument;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.expr.Step;
import com.sourceclear.sgl.lang.expr.TraversalArgument;
import com.sourceclear.sgl.lang.expr.Value;
import com.sourceclear.sgl.lang.expr.WildcardArgument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExtractAddVisitor<V, E>
extends ASTVisitor<V, V, Void> {
    private Set<E> edges = new HashSet();
    private Set<V> vertices = new HashSet<V>();
    private Map<String, V> env = new HashMap<String, V>();
    private boolean inAdd = false;
    private final Function<Step, V> vertex;
    private final Function4<String, V, V, Map<String, Object>, E> edge;

    public ExtractAddVisitor(Function<Step, V> vertex, Function4<String, V, V, Map<String, Object>, E> edge) {
        this.vertex = vertex;
        this.edge = edge;
    }

    @Override
    public V visitBindingSequence(BindingSequence bindingSequence) {
        for (Binding binding : bindingSequence.getBindings()) {
            String variable = binding.getVariable();
            this.env.put(variable, this.visit(binding.getExpr()));
        }
        this.visit(bindingSequence.getBody());
        return null;
    }

    @Override
    public V visitSequence(Sequence sequence) {
        for (Action action : sequence.getActions()) {
            this.visit(action);
        }
        return null;
    }

    @Override
    public V visitAddAction(AddAction action) {
        this.inAdd = true;
        Object result = this.visit(action.getTraversal());
        this.inAdd = false;
        return (V)result;
    }

    @Override
    public V visitRemoveAction(RemoveAction action) {
        return null;
    }

    @Override
    public V visitQuery(Query query) {
        return (V)query.getStep().accept(this);
    }

    @Override
    public V visitStep(Step step) {
        V outVertex = this.resolveVertex(step);
        Optional<Step> next = step.getNext();
        boolean hasEdge = next.map(Step::getName).map(Schema::isEdge).orElse(false);
        if (hasEdge) {
            assert (next.isPresent());
            Step edgeStep = next.get();
            Map<String, Object> edgeArgs = ExtractAddVisitor.resolveEdgeProperties(step.getName(), edgeStep);
            if (!edgeStep.getNext().isPresent()) {
                throw new RuntimeException("no vertex after edge " + edgeStep.getName());
            }
            V inVertex = this.resolveVertex(edgeStep.getNext().get());
            this.edges.add(this.edge.apply(edgeStep.getName(), outVertex, inVertex, edgeArgs));
        } else if (this.inAdd) {
            this.vertices.add(outVertex);
        }
        return outVertex;
    }

    @Override
    public Void visitPredicateArgument(PredicateArgument predicateArgument) {
        return null;
    }

    @Override
    public Void visitTraversalArgument(TraversalArgument traversalArgument) {
        return null;
    }

    @Override
    public Void visitWildcardArgument(WildcardArgument wildcardArgument) {
        return null;
    }

    @Override
    public V visitPatterns(Patterns patterns) {
        if (!patterns.isSingleton()) {
            throw new RuntimeException("use of arbitrary patterns not supported");
        }
        return (V)patterns.getSteps().get(0).accept(this);
    }

    private V resolveVertex(Step step) {
        String name = step.getName();
        if (this.env.containsKey(name) && step.getArguments().isEmpty()) {
            return this.env.get(name);
        }
        return this.vertex.apply(step);
    }

    private static Map<String, Object> resolveEdgeProperties(String stepName, Step edgeStep) {
        boolean all = edgeStep.getArguments().stream().allMatch(e -> e.getKeyword().isPresent());
        boolean none = edgeStep.getArguments().stream().noneMatch(e -> e.getKeyword().isPresent());
        if (!all && !none) {
            throw new RuntimeException("All edge properties must have arguments, or none must");
        }
        List args = edgeStep.getArguments().stream().map(Argument::asValue).map(Value::getValue).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (edgeStep.getArguments().isEmpty()) {
            return result;
        }
        if (none) {
            int size = Schema.getEdgeProperties().size();
            List<String> argNames = Schema.getEdgeProperties().get(stepName);
            for (int i = 0; i < size; ++i) {
                result.put(argNames.get(i), args.get(i));
            }
        } else {
            for (Argument argument : edgeStep.getArguments()) {
                result.put(argument.getKeyword().get(), argument.asValue().getValue());
            }
        }
        return result;
    }

    public Set<V> getVertices() {
        return this.vertices;
    }

    public Set<E> getEdges() {
        return this.edges;
    }

    @FunctionalInterface
    public static interface Function4<A, B, C, D, E> {
        public E apply(A var1, B var2, C var3, D var4);
    }
}

