/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.sgl.Utility;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Schema {
    public static final String LIBRARY = "library";
    public static final String LIBRARY_HASH = "library_hash";
    public static final String FILE = "file";
    public static final String METHOD_HASH = "method_hash";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String VERSION_RANGE = "version_range";
    public static final String VULNERABILITY = "vulnerability";
    public static final String VULNERABILITY_SOURCE = "vulnerability_source";
    public static final String LICENSE = "license";
    public static final String VARIABLE = "variable";
    private static final ImmutableSet<String> vertexTypes = ImmutableSet.of((Object)"library", (Object)"library_hash", (Object)"file", (Object)"method_hash", (Object)"method", (Object)"class", (Object[])new String[]{"version_range", "vulnerability", "vulnerability_source", "license", "variable"});
    private static final ImmutableSet<String> edgeTypes = ImmutableSet.of((Object)"depends_on", (Object)"embeds", (Object)"has_library_hash", (Object)"has_file", (Object)"has_method_hash", (Object)"has_method", (Object[])new String[]{"calls", "has_class", "extends", "defines", "has_library", "has_vulnerable_method", "has_version_range", "source_described_by", "licensed_under", "affects", "input_to", "output_to"});
    private static final ImmutableSet<String> properties = ImmutableSet.of((Object)"language", (Object)"coord1", (Object)"coord2", (Object)"version", (Object)"subdirectory", (Object)"hash", (Object[])new String[]{"name", "length", "module_name", "class_name", "method_name", "descriptor", "at", "from", "to", "cwe", "query", "type", "identity", "description", "released"});
    private static final ImmutableMap<String, List<String>> allProperties = ImmutableMap.builder().put((Object)"library", Utility.list("language", "coord1", "coord2", "version")).put((Object)"library_hash", Utility.list("hash")).put((Object)"file", Utility.list("language", "coord1", "coord2", "version", "name")).put((Object)"method_hash", Utility.list("length", "hash")).put((Object)"method", Utility.list("language", "coord1", "coord2", "version", "module_name", "class_name", "method_name", "descriptor")).put((Object)"class", Utility.list("language", "coord1", "coord2", "version", "name")).put((Object)"version_range", Utility.list("language", "coord1", "coord2", "from", "to")).put((Object)"vulnerability", Utility.list("cwe", "query")).put((Object)"vulnerability_source", Utility.list("type", "identity", "description", "released")).put((Object)"license", Utility.list("name")).put((Object)"variable", Utility.list("language", "coord1", "coord2", "version", "module_name", "class_name", "method_name", "descriptor", "name")).build();
    private static final ImmutableMap<String, Set<String>> vertexProperties = ImmutableMap.builder().put((Object)"library", Utility.set("language", "coord1", "coord2", "version")).put((Object)"library_hash", Utility.set("hash")).put((Object)"file", Utility.set("name")).put((Object)"method_hash", Utility.set("hash")).put((Object)"method", Utility.set("module_name", "class_name", "method_name", "descriptor")).put((Object)"class", Utility.set("name")).put((Object)"version_range", Utility.set("language", "coord1", "coord2")).put((Object)"vulnerability", Utility.set("cwe")).put((Object)"vulnerability_source", Utility.set("description", "released")).put((Object)"license", Utility.set("name")).put((Object)"variable", Utility.set("language", "coord1", "coord2", "version", "module_name", "class_name", "method_name", "descriptor", "name")).build();
    private static final ImmutableMap<String, Set<String>> indexedProperties = ImmutableMap.builder().put((Object)"library", Utility.set("language", "coord1", "coord2", "version")).put((Object)"library_hash", Utility.set("hash")).put((Object)"file", Utility.set("name")).put((Object)"method_hash", Utility.set("hash")).put((Object)"method", Utility.set("module_name", "class_name", "method_name", "descriptor")).put((Object)"class", Utility.set("name")).put((Object)"version_range", Utility.set("coord1", "coord2")).put((Object)"vulnerability", Utility.set("cwe")).put((Object)"vulnerability_source", Utility.set(new String[0])).put((Object)"license", Utility.set("name")).put((Object)"variable", Utility.set(new String[0])).build();
    private static final ImmutableMap<String, Set<String>> partitionKeyProperties = ImmutableMap.builder().put((Object)"library", Utility.set("language", "coord1", "coord2", "version")).put((Object)"library_hash", Utility.set("hash")).put((Object)"file", Utility.set("language", "coord1", "coord2", "version", "name")).put((Object)"method_hash", Utility.set("length", "hash")).put((Object)"method", Utility.set("language", "coord1", "coord2", "version", "module_name", "class_name", "method_name", "descriptor")).put((Object)"class", Utility.set("language", "coord1", "coord2", "version", "name")).put((Object)"version_range", Utility.set("language", "coord1", "coord2", "from", "to")).put((Object)"vulnerability", Utility.set("cwe", "query")).put((Object)"vulnerability_source", Utility.set("type", "identity")).put((Object)"license", Utility.set("name")).put((Object)"variable", Utility.set("language", "coord1", "coord2", "version", "module_name", "class_name", "method_name", "descriptor", "name")).build();
    private static final ImmutableMap<String, String> reversedEdges = ImmutableMap.builder().put((Object)"dependent_on", (Object)"depends_on").put((Object)"embedded_in", (Object)"embeds").put((Object)"called_by", (Object)"calls").put((Object)"extended_by", (Object)"extends").put((Object)"defined_by", (Object)"defines").put((Object)"in_library", (Object)"has_class").put((Object)"method_in_library", (Object)"has_method").put((Object)"hash_for_library", (Object)"has_library_hash").put((Object)"file_in_library", (Object)"has_file").put((Object)"hash_in_file", (Object)"has_method_hash").put((Object)"method_in_version_range", (Object)"has_vulnerable_method").put((Object)"library_in_version_range", (Object)"has_library").put((Object)"version_range_in_vulnerability", (Object)"has_version_range").put((Object)"license_for_library", (Object)"licensed_under").put((Object)"describes_source", (Object)"source_described_by").put((Object)"has_input", (Object)"input_to").put((Object)"has_output", (Object)"output_to").build();
    private static final ImmutableSet<String> specialSteps = ImmutableSet.of((Object)"where", (Object)"not", (Object)"union", (Object)"start", (Object)"limit", (Object)"count", (Object[])new String[]{"path", "project", "select", "order_by", "identity", "value_map", "id", "state_put", "state_get", "dedup", "time_limit", "edge"});
    private static final ImmutableMap<String, List<String>> edgeProperties = ImmutableMap.builder().put((Object)"calls", Arrays.asList("at")).build();

    static Set<String> allStrings() {
        HashSet<String> result = new HashSet<String>();
        result.addAll((Collection<String>)specialSteps);
        result.addAll((Collection<String>)edgeTypes);
        result.addAll((Collection<String>)vertexTypes);
        result.addAll((Collection<String>)reversedEdges.keySet());
        result.addAll(properties.stream().map(p -> p + ":").collect(Collectors.toSet()));
        return result;
    }

    public static String getDirectEdge(String e) {
        return e.replace("*", "");
    }

    public static boolean isEdge(String e) {
        return edgeTypes.contains((Object)e);
    }

    public static boolean isVertex(String v) {
        return vertexTypes.contains((Object)v);
    }

    public static boolean isReverseEdge(String e) {
        return reversedEdges.keySet().contains((Object)e);
    }

    public static boolean isTransitive(String e) {
        return e.endsWith("*");
    }

    public static String getReverseEdge(String e) {
        return (String)reversedEdges.get((Object)e);
    }

    public static boolean isSpecialStep(String s) {
        return specialSteps.contains((Object)s);
    }

    public static int getVertexArity(String s) {
        return ((List)allProperties.get((Object)s)).size();
    }

    public static List<String> getAllProperties(String type) {
        return (List)allProperties.get((Object)type);
    }

    public static Set<String> getIndexedProperties(String type) {
        return (Set)indexedProperties.get((Object)type);
    }

    public static Set<String> getPartitionKeyProperties(String type) {
        return (Set)partitionKeyProperties.get((Object)type);
    }

    public static Set<String> getVertexProperties(String type) {
        return (Set)vertexProperties.get((Object)type);
    }

    public static Map<String, List<String>> getEdgeProperties() {
        return edgeProperties;
    }
}

