/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.google.common.collect.Iterators;
import com.sourceclear.sgl.gremlin.SGLTraversalSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class SGLGraph
implements Graph {
    private final TinkerGraph graph;

    public SGLGraph(TinkerGraph graph) {
        this.graph = graph;
    }

    public SGLGraph() {
        this(TinkerGraph.open());
    }

    public Builder build() {
        return new Builder();
    }

    public SGLGraph condense() {
        return this.condense(Collections.emptySet());
    }

    public SGLGraph condense(Set<Vertex> targets) {
        SGLGraph condensed = new SGLGraph();
        Set sccs = this.traversal().getSCCs().filter(t -> ((Set)t.get()).size() != 1).toSet();
        HashMap<Vertex, Vertex> collapsed = new HashMap<Vertex, Vertex>();
        int component = 0;
        for (Set scc : sccs) {
            Vertex collapsedVert = condensed.addVertex(T.id, component++, T.label, "collapsed_vertex");
            for (Vertex sc : scc) {
                collapsed.put(sc, collapsedVert);
            }
        }
        Predicate<Vertex> wasCollapsed = v -> collapsed.containsKey(v) && !targets.contains(v);
        this.graph.vertices(new Object[0]).forEachRemaining(v -> {
            if (!wasCollapsed.test((Vertex)v)) {
                SGLGraph.copyInto(v, (Graph)condensed);
            }
        });
        this.graph.edges(new Object[0]).forEachRemaining(e -> {
            if (wasCollapsed.test(e.inVertex()) && wasCollapsed.test(e.outVertex())) {
                Vertex to = (Vertex)collapsed.get(e.inVertex());
                Vertex from = (Vertex)collapsed.get(e.outVertex());
                if (from != to) {
                    to.addEdge("collapsed_edge", from, new Object[0]);
                }
            } else if (wasCollapsed.test(e.inVertex())) {
                SGLGraph.copyInto(e, SGLGraph.copyInto(e.outVertex(), (Graph)condensed), (Vertex)collapsed.get(e.inVertex()), condensed);
            } else if (wasCollapsed.test(e.outVertex())) {
                SGLGraph.copyInto(e, (Vertex)collapsed.get(e.outVertex()), SGLGraph.copyInto(e.inVertex(), (Graph)condensed), condensed);
            } else {
                SGLGraph.copyInto(e, (Graph)condensed);
            }
        });
        return condensed;
    }

    public Vertex addVertex(Object ... keyValues) {
        return this.graph.addVertex(keyValues);
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        return (C)this.graph.compute(graphComputerClass);
    }

    public GraphComputer compute() throws IllegalArgumentException {
        return this.graph.compute();
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.graph.vertices(vertexIds);
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.graph.edges(edgeIds);
    }

    public Transaction tx() {
        return this.graph.tx();
    }

    public void close() {
        this.graph.close();
    }

    public Graph.Variables variables() {
        return this.graph.variables();
    }

    public Configuration configuration() {
        return this.graph.configuration();
    }

    public SGLTraversalSource traversal() {
        return new SGLTraversalSource((Graph)this.graph);
    }

    public void dfs(Vertex v, Set<Vertex> seen, boolean checkCycles, Consumer<Vertex> pre, Consumer<Vertex> post) {
        pre.accept(v);
        seen.add(v);
        this.graph.traversal().V(new Object[]{v.id()}).out(new String[0]).filter(t -> !checkCycles || !seen.contains(t.get())).forEachRemaining(v1 -> this.dfs((Vertex)v1, seen, checkCycles, pre, post));
        post.accept(v);
    }

    private static void copyInto(Edge e, Graph g) {
        SGLGraph.copyInto(e, SGLGraph.copyInto(e.outVertex(), g), SGLGraph.copyInto(e.inVertex(), g), g);
    }

    private static void copyInto(Edge e, Vertex out, Vertex in, Graph g) {
        if (Iterators.contains((Iterator)out.vertices(Direction.OUT, new String[]{e.label()}), (Object)in)) {
            return;
        }
        Edge edge = out.addEdge(e.label(), in, new Object[0]);
        e.properties(new String[0]).forEachRemaining(p -> edge.property(p.key(), p.value()));
    }

    private static Vertex copyInto(Vertex v, Graph g) {
        Iterator contains = g.vertices(new Object[]{v.id()});
        if (contains.hasNext()) {
            return (Vertex)contains.next();
        }
        Vertex vertex = g.addVertex(new Object[]{T.id, v.id()});
        v.properties(new String[0]).forEachRemaining(p -> vertex.property(p.key(), p.value()));
        return vertex;
    }

    public class Builder {
        Vertex vertex(String name) {
            return SGLGraph.this.graph.addVertex(new Object[]{T.id, name});
        }

        Builder edge(Vertex from, Vertex to) {
            from.addEdge("e", to, new Object[0]);
            return this;
        }

        GraphTraversalSource traversal() {
            return SGLGraph.this.graph.traversal();
        }
    }
}

